/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.export.pdf;

import com.bstek.ureport.definition.Border;
import com.bstek.ureport.definition.BorderStyle;
import com.bstek.ureport.definition.CellStyle;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPCellEvent;
import java.awt.Color;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class CellBorderEvent
implements PdfPCellEvent {
    private CellStyle style;
    private CellStyle customStyle;

    public CellBorderEvent(CellStyle style, CellStyle customStyle) {
        this.style = style;
        this.customStyle = customStyle;
    }

    public void cellLayout(PdfPCell cell, Rectangle position, PdfContentByte[] canvases) {
        Border leftBorder = this.style.getLeftBorder();
        if (this.customStyle != null && this.customStyle.getLeftBorder() != null) {
            leftBorder = this.customStyle.getLeftBorder();
        }
        if (leftBorder != null) {
            PdfContentByte cb = this.bulidCellBorder(canvases, leftBorder);
            cb.moveTo(position.getLeft(), position.getTop());
            cb.lineTo(position.getLeft(), position.getBottom());
            cb.stroke();
            if (leftBorder.getStyle().equals((Object)BorderStyle.doublesolid)) {
                cb.moveTo(position.getLeft() + 2.0f, position.getTop() - 2.0f);
                cb.lineTo(position.getLeft() + 2.0f, position.getBottom() + 2.0f);
                cb.stroke();
            }
            cb.restoreState();
        }
        Border topBorder = this.style.getTopBorder();
        if (this.customStyle != null && this.customStyle.getTopBorder() != null) {
            topBorder = this.customStyle.getTopBorder();
        }
        if (topBorder != null) {
            PdfContentByte cb = this.bulidCellBorder(canvases, topBorder);
            cb.moveTo(position.getLeft(), position.getTop());
            cb.lineTo(position.getRight(), position.getTop());
            cb.stroke();
            if (topBorder.getStyle().equals((Object)BorderStyle.doublesolid)) {
                cb.moveTo(position.getLeft() + 2.0f, position.getTop() - 2.0f);
                cb.lineTo(position.getRight() - 2.0f, position.getTop() - 2.0f);
                cb.stroke();
            }
            cb.restoreState();
        }
        Border rightBorder = this.style.getRightBorder();
        if (this.customStyle != null && this.customStyle.getRightBorder() != null) {
            rightBorder = this.customStyle.getRightBorder();
        }
        if (rightBorder != null) {
            PdfContentByte cb = this.bulidCellBorder(canvases, rightBorder);
            cb.moveTo(position.getRight(), position.getTop());
            cb.lineTo(position.getRight(), position.getBottom());
            cb.stroke();
            if (rightBorder.getStyle().equals((Object)BorderStyle.doublesolid)) {
                cb.moveTo(position.getRight() - 2.0f, position.getTop() - 2.0f);
                cb.lineTo(position.getRight() - 2.0f, position.getBottom() + 2.0f);
                cb.stroke();
            }
            cb.restoreState();
        }
        Border bottomBorder = this.style.getBottomBorder();
        if (this.customStyle != null && this.customStyle.getBottomBorder() != null) {
            bottomBorder = this.customStyle.getBottomBorder();
        }
        if (bottomBorder != null) {
            PdfContentByte cb = this.bulidCellBorder(canvases, bottomBorder);
            cb.moveTo(position.getLeft(), position.getBottom());
            cb.lineTo(position.getRight(), position.getBottom());
            cb.stroke();
            if (bottomBorder.getStyle().equals((Object)BorderStyle.doublesolid)) {
                cb.moveTo(position.getLeft() + 2.0f, position.getBottom() + 2.0f);
                cb.lineTo(position.getRight() - 2.0f, position.getBottom() + 2.0f);
                cb.stroke();
            }
            cb.restoreState();
        }
    }

    private PdfContentByte bulidCellBorder(PdfContentByte[] canvases, Border border) {
        PdfContentByte cb = canvases[2];
        cb.saveState();
        BigDecimal w = new BigDecimal(border.getWidth());
        cb.setLineWidth(w.divide(new BigDecimal(2), 10, RoundingMode.HALF_UP).floatValue());
        if (border.getStyle().equals((Object)BorderStyle.dashed)) {
            cb.setLineDash(new float[]{2.0f, 3.0f, 1.0f}, 2.0f);
        }
        String[] borderColor = border.getColor().split(",");
        cb.setColorStroke(new Color(Integer.valueOf(borderColor[0]), Integer.valueOf(borderColor[1]), Integer.valueOf(borderColor[2])));
        return cb;
    }
}

