/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.export;

import com.bstek.ureport.build.paging.Page;
import com.bstek.ureport.cache.CacheUtils;
import com.bstek.ureport.chart.ChartData;
import com.bstek.ureport.definition.ReportDefinition;
import com.bstek.ureport.export.ExportConfigure;
import com.bstek.ureport.export.ExportManager;
import com.bstek.ureport.export.PageBuilder;
import com.bstek.ureport.export.ReportRender;
import com.bstek.ureport.export.SinglePageData;
import com.bstek.ureport.export.excel.high.ExcelProducer;
import com.bstek.ureport.export.excel.low.Excel97Producer;
import com.bstek.ureport.export.html.HtmlProducer;
import com.bstek.ureport.export.html.HtmlReport;
import com.bstek.ureport.export.pdf.PdfProducer;
import com.bstek.ureport.export.word.high.WordProducer;
import com.bstek.ureport.model.Report;
import java.util.List;
import java.util.Map;

public class ExportManagerImpl
implements ExportManager {
    private ReportRender reportRender;
    private HtmlProducer htmlProducer = new HtmlProducer();
    private WordProducer wordProducer = new WordProducer();
    private ExcelProducer excelProducer = new ExcelProducer();
    private Excel97Producer excel97Producer = new Excel97Producer();
    private PdfProducer pdfProducer = new PdfProducer();

    @Override
    public HtmlReport exportHtml(String file, String contextPath, Map<String, Object> parameters) {
        ReportDefinition reportDefinition = this.reportRender.getReportDefinition(file);
        Report report = this.reportRender.render(reportDefinition, parameters);
        Map<String, ChartData> chartMap = report.getContext().getChartDataMap();
        if (chartMap.size() > 0) {
            CacheUtils.storeChartDataMap(chartMap);
        }
        HtmlReport htmlReport = new HtmlReport();
        String content = this.htmlProducer.produce(report);
        htmlReport.setContent(content);
        if (reportDefinition.getPaper().isColumnEnabled()) {
            htmlReport.setColumn(reportDefinition.getPaper().getColumnCount());
        }
        htmlReport.setStyle(reportDefinition.getStyle());
        htmlReport.setSearchFormData(reportDefinition.buildSearchFormData(report.getContext().getDatasetMap(), parameters));
        htmlReport.setReportAlign(report.getPaper().getHtmlReportAlign().name());
        htmlReport.setChartDatas(report.getContext().getChartDataMap().values());
        htmlReport.setHtmlIntervalRefreshValue(report.getPaper().getHtmlIntervalRefreshValue());
        return htmlReport;
    }

    @Override
    public HtmlReport exportHtml(String file, String contextPath, Map<String, Object> parameters, int pageIndex) {
        ReportDefinition reportDefinition = this.reportRender.getReportDefinition(file);
        Report report = this.reportRender.render(reportDefinition, parameters);
        Map<String, ChartData> chartMap = report.getContext().getChartDataMap();
        if (chartMap.size() > 0) {
            CacheUtils.storeChartDataMap(chartMap);
        }
        SinglePageData pageData = PageBuilder.buildSinglePageData(pageIndex, report);
        List<Page> pages = pageData.getPages();
        String content = null;
        content = pages.size() == 1 ? this.htmlProducer.produce(report.getContext(), pages.get(0), false) : this.htmlProducer.produce(report.getContext(), pages, pageData.getColumnMargin(), false);
        HtmlReport htmlReport = new HtmlReport();
        htmlReport.setContent(content);
        if (reportDefinition.getPaper().isColumnEnabled()) {
            htmlReport.setColumn(reportDefinition.getPaper().getColumnCount());
        }
        htmlReport.setStyle(reportDefinition.getStyle());
        htmlReport.setSearchFormData(reportDefinition.buildSearchFormData(report.getContext().getDatasetMap(), parameters));
        htmlReport.setPageIndex(pageIndex);
        htmlReport.setTotalPage(pageData.getTotalPages());
        htmlReport.setReportAlign(report.getPaper().getHtmlReportAlign().name());
        htmlReport.setChartDatas(report.getContext().getChartDataMap().values());
        htmlReport.setHtmlIntervalRefreshValue(report.getPaper().getHtmlIntervalRefreshValue());
        return htmlReport;
    }

    @Override
    public void exportPdf(ExportConfigure config) {
        String file = config.getFile();
        Map<String, Object> parameters = config.getParameters();
        ReportDefinition reportDefinition = this.reportRender.getReportDefinition(file);
        Report report = this.reportRender.render(reportDefinition, parameters);
        this.pdfProducer.produce(report, config.getOutputStream());
    }

    @Override
    public void exportWord(ExportConfigure config) {
        String file = config.getFile();
        Map<String, Object> parameters = config.getParameters();
        ReportDefinition reportDefinition = this.reportRender.getReportDefinition(file);
        Report report = this.reportRender.render(reportDefinition, parameters);
        this.wordProducer.produce(report, config.getOutputStream());
    }

    @Override
    public void exportExcel(ExportConfigure config) {
        String file = config.getFile();
        Map<String, Object> parameters = config.getParameters();
        ReportDefinition reportDefinition = this.reportRender.getReportDefinition(file);
        Report report = this.reportRender.render(reportDefinition, parameters);
        this.excelProducer.produce(report, config.getOutputStream());
    }

    @Override
    public void exportExcel97(ExportConfigure config) {
        String file = config.getFile();
        Map<String, Object> parameters = config.getParameters();
        ReportDefinition reportDefinition = this.reportRender.getReportDefinition(file);
        Report report = this.reportRender.render(reportDefinition, parameters);
        this.excel97Producer.produce(report, config.getOutputStream());
    }

    @Override
    public void exportExcelWithPaging(ExportConfigure config) {
        String file = config.getFile();
        Map<String, Object> parameters = config.getParameters();
        ReportDefinition reportDefinition = this.reportRender.getReportDefinition(file);
        Report report = this.reportRender.render(reportDefinition, parameters);
        this.excelProducer.produceWithPaging(report, config.getOutputStream());
    }

    @Override
    public void exportExcel97WithPaging(ExportConfigure config) {
        String file = config.getFile();
        Map<String, Object> parameters = config.getParameters();
        ReportDefinition reportDefinition = this.reportRender.getReportDefinition(file);
        Report report = this.reportRender.render(reportDefinition, parameters);
        this.excel97Producer.produceWithPaging(report, config.getOutputStream());
    }

    @Override
    public void exportExcelWithPagingSheet(ExportConfigure config) {
        String file = config.getFile();
        Map<String, Object> parameters = config.getParameters();
        ReportDefinition reportDefinition = this.reportRender.getReportDefinition(file);
        Report report = this.reportRender.render(reportDefinition, parameters);
        this.excelProducer.produceWithSheet(report, config.getOutputStream());
    }

    @Override
    public void exportExcel97WithPagingSheet(ExportConfigure config) {
        String file = config.getFile();
        Map<String, Object> parameters = config.getParameters();
        ReportDefinition reportDefinition = this.reportRender.getReportDefinition(file);
        Report report = this.reportRender.render(reportDefinition, parameters);
        this.excel97Producer.produceWithSheet(report, config.getOutputStream());
    }

    public void setReportRender(ReportRender reportRender) {
        this.reportRender = reportRender;
    }
}

