/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.definition.searchform;

import com.alibaba.fastjson.JSONObject;
import com.bstek.ureport.Utils;
import com.bstek.ureport.build.Dataset;
import com.bstek.ureport.definition.searchform.InputComponent;
import com.bstek.ureport.definition.searchform.Option;
import com.bstek.ureport.definition.searchform.RenderContext;
import com.bstek.ureport.exception.DatasetUndefinitionException;
import com.bstek.ureport.utils.HttpUtil;
import com.bstek.ureport.utils.ReportConfig;
import java.util.Arrays;
import java.util.List;
import jnpf.util.ServletUtil;
import jnpf.util.context.SpringContext;
import org.apache.commons.lang3.StringUtils;

public class SelectInputComponent
extends InputComponent {
    private ReportConfig reportConfig = (ReportConfig)SpringContext.getBean(ReportConfig.class);
    private String defaultType;
    private String showValue;
    private String defaultValue;
    private boolean useDataset;
    private String dataset;
    private String labelField;
    private String valueField;
    private List<Option> options;

    public String getDefaultType() {
        return this.defaultType;
    }

    public void setDefaultType(String defaultType) {
        this.defaultType = defaultType;
    }

    public String getShowValue() {
        return this.showValue;
    }

    public void setShowValue(String showValue) {
        this.showValue = showValue;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        if (this.useDataset && "2".equals(this.defaultType)) {
            String token = ServletUtil.getRequest().getParameter("token");
            JSONObject object = HttpUtil.httpRequest(this.reportConfig.getUserUrl(), "GET", null, token);
            if ("1".equals(defaultValue)) {
                this.defaultValue = object != null ? object.getString("userId") : "";
            } else if ("2".equals(defaultValue)) {
                this.defaultValue = object != null ? object.getString("departmentId") : "";
            } else if ("3".equals(defaultValue)) {
                this.defaultValue = object != null ? object.getString("organizeId") : "";
            } else if ("4".equals(defaultValue)) {
                this.defaultValue = object != null ? object.getString("positionId") : "";
            } else if ("5".equals(defaultValue)) {
                this.defaultValue = object != null ? object.getString("roleId") : "";
            } else if ("6".equals(defaultValue)) {
                this.defaultValue = object != null ? object.getString("managerId") : "";
            }
        }
    }

    @Override
    String inputHtml(RenderContext context) {
        String name = this.getBindParameter();
        Object pvalue = context.getParameter(name) == null ? (this.defaultValue != null ? this.defaultValue : "") : context.getParameter(name);
        String[] data = pvalue.toString().split(",");
        List<String> list = Arrays.asList(data);
        StringBuilder sb = new StringBuilder();
        sb.append("<select style=\"padding:3px;height:28px\" id='" + context.buildComponentId(this) + "' name='" + name + "' class='form-control' use-dataset = ' " + this.useDataset + " ' dataset = ' " + this.dataset + " ' label-field = ' " + this.labelField + " ' value-field = ' " + this.valueField + " ' default-type = ' " + this.defaultType + " ' default-value = ' " + this.defaultValue + " '>");
        if (this.useDataset && StringUtils.isNotBlank((CharSequence)this.dataset)) {
            Dataset ds = context.getDataset(this.dataset);
            if (ds == null) {
                throw new DatasetUndefinitionException(this.dataset);
            }
            for (Object obj : ds.getData()) {
                Object label = Utils.getProperty(obj, this.labelField);
                Object value = Utils.getProperty(obj, this.valueField);
                String selected = String.valueOf(value).equals(String.valueOf(pvalue)) ? "selected" : "";
                sb.append("<option value='" + String.valueOf(value) + "' " + selected + ">" + String.valueOf(label) + "</option>");
            }
            if (pvalue.equals("")) {
                sb.append("<option value='' selected></option>");
            }
        } else {
            for (Option option : this.options) {
                String value = option.getValue();
                String selected = list.contains(String.valueOf(value)) ? "selected" : "";
                sb.append("<option value='" + value + "' " + selected + ">" + option.getLabel() + "</option>");
            }
            if (pvalue.equals("")) {
                sb.append("<option value='' selected></option>");
            }
        }
        sb.append("</select>");
        return sb.toString();
    }

    @Override
    public String initJs(RenderContext context) {
        String name = this.getBindParameter();
        StringBuilder sb = new StringBuilder();
        sb.append("formElements.push(");
        sb.append("function(){");
        sb.append("if(''==='" + name + "'){");
        sb.append("alert('\u5217\u8868\u6846\u672a\u7ed1\u5b9a\u67e5\u8be2\u53c2\u6570\u540d\uff0c\u4e0d\u80fd\u8fdb\u884c\u67e5\u8be2\u64cd\u4f5c!');");
        sb.append("throw '\u5217\u8868\u6846\u672a\u7ed1\u5b9a\u67e5\u8be2\u53c2\u6570\u540d\uff0c\u4e0d\u80fd\u8fdb\u884c\u67e5\u8be2\u64cd\u4f5c!'");
        sb.append("}");
        sb.append("return {");
        sb.append("\"" + name + "\":");
        sb.append("$('#" + context.buildComponentId(this) + "').val()");
        sb.append("}");
        sb.append("}");
        sb.append(");");
        return sb.toString();
    }

    public boolean isUseDataset() {
        return this.useDataset;
    }

    public String getDataset() {
        return this.dataset;
    }

    public void setDataset(String dataset) {
        this.dataset = dataset;
    }

    public String getLabelField() {
        return this.labelField;
    }

    public void setLabelField(String labelField) {
        this.labelField = labelField;
    }

    public String getValueField() {
        return this.valueField;
    }

    public void setValueField(String valueField) {
        this.valueField = valueField;
    }

    public void setUseDataset(boolean useDataset) {
        this.useDataset = useDataset;
    }

    public void setOptions(List<Option> options) {
        this.options = options;
    }

    public List<Option> getOptions() {
        return this.options;
    }
}

