/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.definition.searchform;

import com.alibaba.fastjson.JSONObject;
import com.bstek.ureport.Utils;
import com.bstek.ureport.build.Dataset;
import com.bstek.ureport.definition.searchform.InputComponent;
import com.bstek.ureport.definition.searchform.Option;
import com.bstek.ureport.definition.searchform.RenderContext;
import com.bstek.ureport.exception.DatasetUndefinitionException;
import com.bstek.ureport.utils.HttpUtil;
import com.bstek.ureport.utils.ReportConfig;
import java.util.Arrays;
import java.util.List;
import jnpf.util.ServletUtil;
import jnpf.util.context.SpringContext;

public class RadioInputComponent
extends InputComponent {
    private ReportConfig reportConfig = (ReportConfig)SpringContext.getBean(ReportConfig.class);
    private boolean useDataset;
    private String dataset;
    private String labelField;
    private String valueField;
    private String defaultType;
    private String showValue;
    private String defaultValue;
    private boolean optionsInline;
    private List<Option> options;

    public boolean isUseDataset() {
        return this.useDataset;
    }

    public void setUseDataset(boolean useDataset) {
        this.useDataset = useDataset;
    }

    public String getDataset() {
        return this.dataset;
    }

    public void setDataset(String dataset) {
        this.dataset = dataset;
    }

    public String getLabelField() {
        return this.labelField;
    }

    public void setLabelField(String labelField) {
        this.labelField = labelField;
    }

    public String getValueField() {
        return this.valueField;
    }

    public void setValueField(String valueField) {
        this.valueField = valueField;
    }

    public String getDefaultType() {
        return this.defaultType;
    }

    public void setDefaultType(String defaultType) {
        this.defaultType = defaultType;
    }

    public String getShowValue() {
        return this.showValue;
    }

    public void setShowValue(String showValue) {
        this.showValue = showValue;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        if (this.useDataset && "2".equals(this.defaultType)) {
            String token = ServletUtil.getRequest().getParameter("token");
            JSONObject object = HttpUtil.httpRequest(this.reportConfig.getUserUrl(), "GET", null, token);
            if ("1".equals(defaultValue)) {
                this.defaultValue = object != null ? object.getString("userId") : "";
            } else if ("2".equals(defaultValue)) {
                this.defaultValue = object != null ? object.getString("departmentId") : "";
            } else if ("3".equals(defaultValue)) {
                this.defaultValue = object != null ? object.getString("organizeId") : "";
            } else if ("4".equals(defaultValue)) {
                this.defaultValue = object != null ? object.getString("positionId") : "";
            } else if ("5".equals(defaultValue)) {
                this.defaultValue = object != null ? object.getString("roleId") : "";
            } else if ("6".equals(defaultValue)) {
                this.defaultValue = object != null ? object.getString("managerId") : "";
            }
        }
    }

    @Override
    String inputHtml(RenderContext context) {
        StringBuilder sb = new StringBuilder();
        String name = this.getBindParameter();
        Object pvalue = context.getParameter(name) == null ? (this.defaultValue != null ? this.defaultValue : "") : context.getParameter(name);
        String[] data = pvalue.toString().split(",");
        List<String> list = Arrays.asList(data);
        sb.append("<div>");
        Object value = "";
        Object label = "";
        if (this.useDataset) {
            Dataset ds = context.getDataset(this.dataset);
            if (ds == null) {
                throw new DatasetUndefinitionException(this.dataset);
            }
            for (Object obj : ds.getData()) {
                String checked;
                label = Utils.getProperty(obj, this.labelField);
                value = Utils.getProperty(obj, this.valueField);
                String string = checked = String.valueOf(value).equals(this.defaultValue) ? "checked" : "";
                if (this.optionsInline) {
                    sb.append("<span class='checkbox-inline' style='padding-top:0px;padding-left:2px;padding-top:0px'><input value='" + String.valueOf(value) + "' " + checked + " type='radio' name='" + name + "' use-dataset = ' " + this.useDataset + " ' dataset = ' " + this.dataset + " ' label-field = ' " + this.labelField + " ' value-field = ' " + this.valueField + " ' default-type = ' " + this.defaultType + " ' default-value = ' " + this.defaultValue + " '> " + String.valueOf(label) + "</span>");
                    continue;
                }
                sb.append("<span class='checkbox'><input value='" + String.valueOf(value) + "' type='radio' " + checked + " name='" + name + "' style='margin-left: auto' use-dataset = ' " + this.useDataset + " ' dataset = ' " + this.dataset + " ' label-field = ' " + this.labelField + " ' value-field = ' " + this.valueField + " ' default-type = ' " + this.defaultType + " ' default-value = ' " + this.defaultValue + " '> <span style=\"margin-left:15px\">" + String.valueOf(label) + "</span></span>");
            }
        } else {
            for (Option option : this.options) {
                String checked;
                value = option.getValue();
                label = option.getLabel();
                String string = checked = list.contains(String.valueOf(value)) ? "checked" : "";
                if (this.optionsInline) {
                    sb.append("<span class='checkbox-inline' style='padding-top:0px;padding-left:2px;padding-top:0px'><input value='" + String.valueOf(value) + "' " + checked + " type='radio' name='" + name + "' use-dataset = ' " + this.useDataset + " ' dataset = ' " + this.dataset + " ' label-field = ' " + this.labelField + " ' value-field = ' " + this.valueField + " ' default-type = ' " + this.defaultType + " ' default-value = ' " + this.defaultValue + " '> " + String.valueOf(label) + "</span>");
                    continue;
                }
                sb.append("<span class='checkbox'><input value='" + String.valueOf(value) + "' type='radio' " + checked + " name='" + name + "' style='margin-left: auto' use-dataset = ' " + this.useDataset + " ' dataset = ' " + this.dataset + " ' label-field = ' " + this.labelField + " ' value-field = ' " + this.valueField + " ' default-type = ' " + this.defaultType + " ' default-value = ' " + this.defaultValue + " '> <span style=\"margin-left:15px\">" + String.valueOf(label) + "</span></span>");
            }
        }
        sb.append("</div>");
        return sb.toString();
    }

    @Override
    public String initJs(RenderContext context) {
        String name = this.getBindParameter();
        StringBuilder sb = new StringBuilder();
        sb.append("formElements.push(");
        sb.append("function(){");
        sb.append("if(''==='" + name + "'){");
        sb.append("alert('\u5355\u9009\u6846\u672a\u7ed1\u5b9a\u67e5\u8be2\u53c2\u6570\u540d\uff0c\u4e0d\u80fd\u8fdb\u884c\u67e5\u8be2\u64cd\u4f5c!');");
        sb.append("throw '\u5355\u9009\u6846\u672a\u7ed1\u5b9a\u67e5\u8be2\u53c2\u6570\u540d\uff0c\u4e0d\u80fd\u8fdb\u884c\u67e5\u8be2\u64cd\u4f5c!'");
        sb.append("}");
        sb.append("return {");
        sb.append("\"" + name + "\":");
        sb.append("$(\"input[name='" + this.getBindParameter() + "']:checked\").val()");
        sb.append("}");
        sb.append("}");
        sb.append(");");
        return sb.toString();
    }

    public void setOptionsInline(boolean optionsInline) {
        this.optionsInline = optionsInline;
    }

    public boolean isOptionsInline() {
        return this.optionsInline;
    }

    public void setOptions(List<Option> options) {
        this.options = options;
    }

    public List<Option> getOptions() {
        return this.options;
    }
}

