/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.definition.datasource;

import com.bstek.ureport.build.Dataset;
import com.bstek.ureport.definition.dataset.DatasetDefinition;
import com.bstek.ureport.definition.dataset.SqlDatasetDefinition;
import com.bstek.ureport.definition.datasource.DatasourceDefinition;
import com.bstek.ureport.definition.datasource.DatasourceType;
import com.bstek.ureport.exception.ReportComputeException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jnpf.database.util.ConnUtil;
import jnpf.util.DesUtil;

public class JdbcDatasourceDefinition
implements DatasourceDefinition {
    private String name;
    private String driver;
    private String url;
    private String username;
    private String password;
    private List<DatasetDefinition> datasets;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Dataset> buildDatasets(Connection conn, Map<String, Object> parameters) {
        if (this.datasets == null || this.datasets.size() == 0) {
            return null;
        }
        if (conn == null) {
            conn = this.getConnection();
        }
        ArrayList<Dataset> list = new ArrayList<Dataset>();
        try {
            for (DatasetDefinition dsDef : this.datasets) {
                SqlDatasetDefinition sqlDataset = (SqlDatasetDefinition)dsDef;
                Dataset ds = sqlDataset.buildDataset(parameters, conn, false);
                list.add(ds);
            }
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException e) {
                throw new ReportComputeException(e);
            }
        }
        return list;
    }

    private Connection getConnection() {
        try {
            String tmpPassword = DesUtil.aesOrDecode((String)this.password, (boolean)false, (boolean)true);
            return ConnUtil.getConn((String)this.username, (String)tmpPassword, (String)this.url);
        }
        catch (Exception e) {
            throw new ReportComputeException(e);
        }
    }

    @Override
    public DatasourceType getType() {
        return DatasourceType.jdbc;
    }

    @Override
    public List<DatasetDefinition> getDatasets() {
        return this.datasets;
    }

    public void setDatasets(List<DatasetDefinition> datasets) {
        this.datasets = datasets;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setName(String name) {
        this.name = name;
    }
}

