/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.definition.dataset;

import cn.hutool.core.date.DateUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.bstek.ureport.Utils;
import com.bstek.ureport.build.Context;
import com.bstek.ureport.build.Dataset;
import com.bstek.ureport.definition.dataset.DatasetDefinition;
import com.bstek.ureport.definition.dataset.Field;
import com.bstek.ureport.definition.dataset.Parameter;
import com.bstek.ureport.definition.datasource.DataType;
import com.bstek.ureport.expression.ExpressionUtils;
import com.bstek.ureport.expression.model.Expression;
import com.bstek.ureport.expression.model.data.ExpressionData;
import com.bstek.ureport.expression.model.data.ObjectExpressionData;
import com.bstek.ureport.utils.ProcedureUtils;
import com.bstek.ureport.utils.TenantLineSqlParseUtil;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.temporal.TemporalAccessor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.springframework.core.env.Environment;
import org.springframework.jdbc.core.ColumnMapRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.datasource.SingleConnectionDataSource;

public class SqlDatasetDefinition
implements DatasetDefinition {
    private static final long serialVersionUID = -1134526105416805870L;
    private static int queryTimeout;
    private static int maxRows;
    private String name;
    private String sql;
    private List<Parameter> parameters;
    private List<Field> fields;
    private Expression sqlExpression;

    public Dataset buildDataset(Map<String, Object> parameterMap, Connection conn, boolean isBuildinDatasource) {
        String sqlForUse = this.sql;
        Context context = new Context(null, parameterMap);
        if (this.sqlExpression != null) {
            sqlForUse = this.executeSqlExpr(this.sqlExpression, context);
        } else {
            Pattern pattern = Pattern.compile("\\$\\{.*?\\}");
            Matcher matcher = pattern.matcher(sqlForUse);
            while (matcher.find()) {
                String substr = matcher.group();
                String sqlExpr = substr.substring(2, substr.length() - 1);
                Expression expr = ExpressionUtils.parseExpression(sqlExpr);
                String result = this.executeSqlExpr(expr, context);
                sqlForUse = sqlForUse.replace(substr, result);
            }
        }
        Utils.logToConsole("RUNTIME SQL:" + sqlForUse);
        Map<String, Object> pmap = this.buildParameters(parameterMap, conn);
        if (ProcedureUtils.isProcedure(sqlForUse)) {
            List<Map<String, Object>> result = ProcedureUtils.procedureQuery(sqlForUse, pmap, conn);
            return new Dataset(this.name, result);
        }
        if (isBuildinDatasource) {
            sqlForUse = TenantLineSqlParseUtil.parseSql(sqlForUse);
        }
        SingleConnectionDataSource datasource = new SingleConnectionDataSource(conn, false);
        NamedParameterJdbcTemplate jdbcTemplate = new NamedParameterJdbcTemplate((DataSource)datasource);
        jdbcTemplate.getJdbcTemplate().setQueryTimeout(queryTimeout);
        jdbcTemplate.getJdbcTemplate().setFetchSize(maxRows);
        jdbcTemplate.getJdbcTemplate().setMaxRows(maxRows);
        Utils.logToConsole("\u6b63\u5728\u6267\u884c\u7684SQL\uff1a" + sqlForUse);
        List list = jdbcTemplate.query(sqlForUse, (SqlParameterSource)new MapSqlParameterSource(pmap), (RowMapper)new ColumnMapRowMapper(){

            protected Object getColumnValue(ResultSet rs, int index) throws SQLException {
                Object result = super.getColumnValue(rs, index);
                if (result instanceof TemporalAccessor) {
                    result = DateUtil.date((TemporalAccessor)((TemporalAccessor)result));
                }
                return result;
            }
        });
        return new Dataset(this.name, list);
    }

    private String parseSql(String sql, Map<String, Object> parameters, Connection connection) {
        String value;
        String key;
        sql = ((String)sql).trim();
        Set<String> keySet = parameters.keySet();
        Iterator<String> iter = keySet.iterator();
        while (iter.hasNext()) {
            key = String.valueOf(iter.next());
            value = String.valueOf(parameters.get(key));
            sql = ((String)sql).replace(key, value);
        }
        if (!(((String)sql).toLowerCase().contains("where") || ((String)sql).toLowerCase().contains("leftjoin") || ((String)sql).toLowerCase().contains("rightjoin") || ((String)sql).toLowerCase().contains("innerjoin"))) {
            sql = (String)sql + " where 1=1 ";
        }
        iter = keySet.iterator();
        while (iter.hasNext()) {
            key = String.valueOf(iter.next());
            if (key.contains(":") && key.contains("@")) continue;
            value = String.valueOf(parameters.get(key));
            sql = (String)sql + " and " + key + " = '" + value + "'";
        }
        return sql;
    }

    private String executeSqlExpr(Expression sqlExpr, Context context) {
        ObjectExpressionData data;
        Object obj;
        String sqlForUse = null;
        ExpressionData<?> exprData = sqlExpr.execute(null, null, context);
        if (exprData instanceof ObjectExpressionData && (obj = (data = (ObjectExpressionData)exprData).getData()) != null) {
            String s = obj.toString();
            sqlForUse = s = s.replaceAll("\\\\", "");
        }
        return sqlForUse;
    }

    private Map<String, Object> buildParameters(Map<String, Object> params, Connection connection) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Parameter param : this.parameters) {
            String name = param.getName();
            DataType datatype = param.getType();
            Object value = param.getDefaultValue();
            if (params != null && params.containsKey(name)) {
                value = params.get(name);
            }
            try {
                DatabaseMetaData metaData = connection.getMetaData();
                if ((metaData.getURL().contains("oracle") || metaData.getURL().contains("dm")) && datatype == DataType.Date) {
                    map.put(name, "TO_DATE('" + String.valueOf(value) + "', 'yyyy-mm-dd hh24:mi:ss')");
                    continue;
                }
                map.put(name, datatype.parse(value));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return map;
    }

    @Override
    public List<Field> getFields() {
        return this.fields;
    }

    public void setSqlExpression(Expression sqlExpression) {
        this.sqlExpression = sqlExpression;
    }

    public void setFields(List<Field> fields) {
        this.fields = fields;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public String getSql() {
        return this.sql;
    }

    static {
        Environment environment = (Environment)SpringUtil.getBean(Environment.class);
        queryTimeout = Integer.valueOf(environment.getProperty("config.queryTimeout", "5"));
        maxRows = Integer.valueOf(environment.getProperty("config.maxRows", "100000"));
    }
}

