/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.console.config;

import cn.dev33.satoken.context.SaHolder;
import cn.dev33.satoken.context.model.SaRequest;
import cn.dev33.satoken.exception.BackResultException;
import cn.hutool.jwt.JWT;
import cn.hutool.jwt.JWTUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bstek.ureport.exception.ReportException;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import jnpf.base.ActionResultCode;
import jnpf.base.UserInfo;
import jnpf.config.ConfigValueUtil;
import jnpf.database.util.TenantDataSourceUtil;
import jnpf.filter.SecurityFilter;
import jnpf.model.tenant.TenantVO;
import jnpf.properties.SecurityProperties;
import jnpf.util.JsonUtil;
import jnpf.util.RedisUtil;
import jnpf.util.StringUtil;
import jnpf.util.TenantHolder;
import jnpf.util.UserProvider;

public class UReportSecurityFilter
extends SecurityFilter {
    private static final String ALL = "*";
    private static final String MAX_AGE = "18000L";
    private ConfigValueUtil configValueUtil;
    private RedisUtil redisUtil;

    public UReportSecurityFilter(SecurityProperties securityProperties, ConfigValueUtil configValueUtil, RedisUtil redisUtil) {
        super(securityProperties, configValueUtil);
        this.configValueUtil = configValueUtil;
        this.redisUtil = redisUtil;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.coress()) {
            return;
        }
        super.doFilter(request, response, chain);
    }

    protected void initAuthenticationInfo() {
        String[] strings;
        JWT jwt;
        Object javaToken;
        SaRequest request = SaHolder.getRequest();
        String token = request.getHeader("Authorization");
        if (token == null) {
            token = request.getParam("token");
        }
        if (StringUtil.isEmpty((String)token)) {
            this.throwNoLogin();
        }
        if ((javaToken = (jwt = JWTUtil.parseToken((String)(token = (strings = token.split(" "))[strings.length - 1]))).getPayload("token")) != null) {
            TenantVO tenantVO;
            UserInfo userInfo = UserProvider.getUser((String)token);
            UserProvider.setLocalLoginUser((UserInfo)userInfo);
            if (userInfo == null || StringUtil.isEmpty((String)userInfo.getUserId())) {
                this.throwNoLogin();
            }
            if (this.configValueUtil.isMultiTenancy() && (tenantVO = TenantDataSourceUtil.switchTenant((String)userInfo.getTenantId())) == null) {
                this.throwNoLogin();
            }
        } else {
            String userId = jwt.getPayload("UserId").toString();
            String tenantId = jwt.getPayload("TenantId").toString();
            if (StringUtil.isEmpty((String)userId) || StringUtil.isEmpty((String)tenantId)) {
                this.throwNoLogin();
            }
            TenantVO tenantVO = new TenantVO();
            tenantVO.setAccountNum(0L);
            tenantVO.setEnCode(tenantId);
            if (this.configValueUtil.isMultiTenancy()) {
                Map<String, Object> uinfoMap = this.getUserInfoNet(userId, tenantId);
                if (uinfoMap != null && !uinfoMap.isEmpty()) {
                    tenantVO = this.getDbInfoNet(tenantId);
                }
                if (tenantVO == null) {
                    this.throwNoLogin();
                }
            } else {
                tenantVO.setType(0);
            }
            UserInfo userInfo = new UserInfo();
            userInfo.setId(userId);
            userInfo.setUserId(userId);
            userInfo.setTenantDbType(tenantVO.getType());
            userInfo.setTenantId(tenantId);
            userInfo.setTenantDbConnectionString(tenantVO.getDbName());
            userInfo.setToken(token);
            UserProvider.setLocalLoginUser((UserInfo)userInfo);
            TenantHolder.setLocalTenantCache((TenantVO)tenantVO);
        }
    }

    private void throwNoLogin() {
        throw new BackResultException((Object)ActionResultCode.SessionOverdue.getMessage());
    }

    private boolean coress() {
        SaRequest request = SaHolder.getRequest();
        String origin = request.getHeader("Origin");
        if (origin == null) {
            origin = request.getHeader("referer");
        }
        SaHolder.getResponse().setHeader("Access-Control-Allow-Origin", origin).setHeader("Access-Control-Allow-Headers", ALL).setHeader("Access-Control-Allow-Methods", ALL).setHeader("Access-Control-Allow-Credentials", "true").setHeader("Access-Control-Expose-Headers", ALL).setHeader("Access-Control-Max-Age", MAX_AGE);
        return request.getMethod().equalsIgnoreCase("options");
    }

    public Map<String, Object> getUserInfoNet(String userId, String tenantId) {
        String userToken = String.format("%s:jnpf:permission:user:%s", tenantId, userId);
        Object uinfoObj = this.redisUtil.getString(userToken);
        if (uinfoObj == null) {
            return Collections.EMPTY_MAP;
        }
        Map uinfoMap = JsonUtil.stringToMap((String)JSONObject.toJSONString((Object)uinfoObj));
        return uinfoMap;
    }

    public TenantVO getDbInfoNet(String tenantId) {
        String tenantToken = "jnpf:global:tenant";
        Object uinfoObj = this.redisUtil.getString(tenantToken);
        if (uinfoObj == null) {
            return null;
        }
        TenantVO tenantVO = null;
        JSONArray tenantInfos = JSONArray.parseArray((String)JSONArray.toJSONString((Object)uinfoObj));
        for (Object tenantInfo : tenantInfos) {
            JSONObject tenantJson = (JSONObject)tenantInfo;
            if (!Objects.equals(tenantId, tenantJson.get((Object)"TenantId"))) continue;
            JSONObject connectionConfig = tenantJson.getJSONObject("connectionConfig");
            boolean isCustome = connectionConfig.getBooleanValue("IsCustom");
            if (isCustome) {
                throw new ReportException("\u6682\u4e0d\u652f\u6301\u6307\u5b9a\u6570\u636e\u6e90\u6a21\u5f0f\u591a\u79df\u6237");
            }
            tenantVO = new TenantVO();
            tenantVO.setEnCode(tenantId);
            JSONArray configList = connectionConfig.getJSONArray("ConfigList");
            for (int i = 0; i < configList.size(); ++i) {
                JSONObject config = configList.getJSONObject(i);
                if (!config.getBooleanValue("IsMaster")) continue;
                tenantVO.setDbName(config.getString("ServiceName"));
            }
        }
        return tenantVO;
    }
}

