/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.chart.dataset.impl;

import com.bstek.ureport.Utils;
import com.bstek.ureport.build.Context;
import com.bstek.ureport.chart.dataset.BaseDataset;
import com.bstek.ureport.chart.dataset.ScatterData;
import com.bstek.ureport.model.Cell;
import com.bstek.ureport.utils.DataUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class ScatterDataset
extends BaseDataset {
    private String datasetName;
    private String categoryProperty;
    private String xProperty;
    private String yProperty;
    private boolean fill = true;
    private double lineTension = 0.2;

    @Override
    public String buildDataJson(Context context, Cell cell) {
        List<?> dataList = DataUtils.fetchData(cell, context, this.datasetName);
        LinkedHashMap map = new LinkedHashMap();
        for (Object obj : dataList) {
            Object category = Utils.getProperty(obj, this.categoryProperty);
            if (category == null) continue;
            Object xValue = Utils.getProperty(obj, this.xProperty);
            Object yValue = Utils.getProperty(obj, this.yProperty);
            if (xValue == null || yValue == null) continue;
            double x = Utils.toBigDecimal(xValue).doubleValue();
            double y = Utils.toBigDecimal(yValue).doubleValue();
            List<ScatterData> list = null;
            if (map.containsKey(category)) {
                list = (List)map.get(category);
            } else {
                list = new ArrayList();
                map.put(category, list);
            }
            list.add(new ScatterData(x, y));
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("\"datasets\":[");
        int index = 0;
        for (Object obj : map.keySet()) {
            if (index > 0) {
                sb.append(",");
            }
            sb.append("{");
            sb.append("\"label\":\"" + String.valueOf(obj) + "\",");
            sb.append("\"fill\":" + this.fill + ",");
            sb.append("\"lineTension\":" + this.lineTension + ",");
            sb.append("\"borderColor\":\"rgb(" + this.getRgbColor(index) + ")\",");
            sb.append("\"backgroundColor\":\"rgba(" + this.getRgbColor(index) + ",0.5)\",");
            sb.append("\"data\":[");
            List list = (List)map.get(obj);
            int i = 0;
            for (ScatterData data : list) {
                if (i > 0) {
                    sb.append(",");
                }
                ++i;
                sb.append("{");
                sb.append("\"x\":" + data.getX() + ",");
                sb.append("\"y\":" + data.getY());
                sb.append("}");
            }
            sb.append("]");
            sb.append("}");
            ++index;
        }
        sb.append("]");
        sb.append("}");
        return sb.toString();
    }

    @Override
    public String getType() {
        return "scatter";
    }

    public String getDatasetName() {
        return this.datasetName;
    }

    public void setDatasetName(String datasetName) {
        this.datasetName = datasetName;
    }

    public String getCategoryProperty() {
        return this.categoryProperty;
    }

    public void setCategoryProperty(String categoryProperty) {
        this.categoryProperty = categoryProperty;
    }

    public String getxProperty() {
        return this.xProperty;
    }

    public void setxProperty(String xProperty) {
        this.xProperty = xProperty;
    }

    public String getyProperty() {
        return this.yProperty;
    }

    public void setyProperty(String yProperty) {
        this.yProperty = yProperty;
    }

    public boolean isFill() {
        return this.fill;
    }

    public void setFill(boolean fill) {
        this.fill = fill;
    }

    public double getLineTension() {
        return this.lineTension;
    }

    public void setLineTension(double lineTension) {
        this.lineTension = lineTension;
    }
}

