/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.chart;

import com.bstek.ureport.build.Context;
import com.bstek.ureport.chart.ChartData;
import com.bstek.ureport.chart.axes.impl.XAxes;
import com.bstek.ureport.chart.axes.impl.YAxes;
import com.bstek.ureport.chart.dataset.Dataset;
import com.bstek.ureport.chart.dataset.impl.BubbleDataset;
import com.bstek.ureport.chart.dataset.impl.ScatterDataset;
import com.bstek.ureport.chart.dataset.impl.category.BarDataset;
import com.bstek.ureport.chart.dataset.impl.category.LineDataset;
import com.bstek.ureport.chart.option.Option;
import com.bstek.ureport.chart.plugins.Plugin;
import com.bstek.ureport.model.Cell;
import java.util.ArrayList;
import java.util.List;

public class Chart {
    private Dataset dataset;
    private XAxes xaxes;
    private YAxes yaxes;
    private List<Option> options = new ArrayList<Option>();
    private List<Plugin> plugins = new ArrayList<Plugin>();

    public ChartData doCompute(Cell cell, Context context) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("\"type\":\"" + this.dataset.getType() + "\",");
        sb.append("\"data\":" + this.dataset.buildDataJson(context, cell) + ",");
        sb.append("\"options\":{");
        boolean withoption = false;
        if (this.options != null && this.options.size() > 0) {
            for (int i = 0; i < this.options.size(); ++i) {
                Option option = this.options.get(i);
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(option.buildOptionJson());
                withoption = true;
            }
        }
        if (this.plugins != null && this.plugins.size() > 0) {
            if (withoption) {
                sb.append(",");
            }
            withoption = true;
            sb.append("\"plugins\": {");
            for (Plugin plugin : this.plugins) {
                String pluginJson = plugin.toJson(this.dataset.getType());
                if (pluginJson == null) continue;
                sb.append(pluginJson);
            }
            sb.append("}");
        } else {
            if (withoption) {
                sb.append(",");
            } else {
                withoption = true;
            }
            sb.append("\"plugins\": {");
            sb.append("\"datalabels\":{\"display\":false}");
            sb.append("}");
        }
        if (this.xaxes != null || this.yaxes != null) {
            if (withoption) {
                sb.append(",");
            }
            withoption = true;
            sb.append("\"scales\":{");
            if (this.xaxes != null) {
                sb.append("\"xAxes\":[");
                sb.append(this.xaxes.toJson());
                sb.append("]");
            }
            if (this.yaxes != null) {
                if (this.xaxes != null) {
                    sb.append(",\"yAxes\":[");
                } else {
                    sb.append("\"yAxes\":[");
                }
                sb.append(this.yaxes.toJson());
                sb.append("]");
            } else if (this.hasYAxes(this.dataset)) {
                sb.append(",\"yAxes\":[{\"ticks\":{\"min\":0}}]");
            }
            sb.append("}");
        } else if (withoption && this.hasYAxes(this.dataset)) {
            sb.append(",");
            sb.append("\"scales\":{\"yAxes\":[]}");
        }
        sb.append("}");
        sb.append("}");
        ChartData chartData = new ChartData(sb.toString(), cell);
        context.addChartData(chartData);
        return chartData;
    }

    private boolean hasYAxes(Dataset dataset) {
        if (dataset instanceof BarDataset) {
            return true;
        }
        if (dataset instanceof LineDataset) {
            return true;
        }
        if (dataset instanceof BubbleDataset) {
            return true;
        }
        return dataset instanceof ScatterDataset;
    }

    public List<Option> getOptions() {
        return this.options;
    }

    public void setOptions(List<Option> options) {
        this.options = options;
    }

    public List<Plugin> getPlugins() {
        return this.plugins;
    }

    public void setPlugins(List<Plugin> plugins) {
        this.plugins = plugins;
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    public void setDataset(Dataset dataset) {
        this.dataset = dataset;
    }

    public XAxes getXaxes() {
        return this.xaxes;
    }

    public void setXaxes(XAxes xaxes) {
        this.xaxes = xaxes;
    }

    public YAxes getYaxes() {
        return this.yaxes;
    }

    public void setYaxes(YAxes yaxes) {
        this.yaxes = yaxes;
    }
}

