/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.cache;

import com.bstek.ureport.cache.DefaultMemoryReportDefinitionCache;
import com.bstek.ureport.cache.ReportCache;
import com.bstek.ureport.cache.ReportDefinitionCache;
import com.bstek.ureport.chart.ChartData;
import com.bstek.ureport.definition.ReportDefinition;
import com.bstek.ureport.model.Cell;
import com.bstek.ureport.utils.UnitUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collection;
import java.util.Map;
import jnpf.util.JsonUtil;
import jnpf.util.RedisUtil;
import jnpf.util.ServletUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class CacheUtils
implements ApplicationContextAware {
    private static ReportCache reportCache;
    private static ReportDefinitionCache reportDefinitionCache;
    private static String CHART_DATA_key;
    private static RedisUtil redisUtil;

    @Autowired
    public void setRedisUtil(RedisUtil redisUtil) {
        CacheUtils.redisUtil = redisUtil;
    }

    public static ChartData getChartData(String chartId) {
        HttpServletRequest request = ServletUtil.getRequest();
        String id = request.getParameter("token") + CHART_DATA_key;
        String data = redisUtil.getHashValues(id, chartId);
        if (StringUtils.isNotEmpty((CharSequence)data)) {
            ChartData chartData = (ChartData)JsonUtil.getJsonToBean((String)data, ChartData.class);
            return chartData;
        }
        return null;
    }

    public static void storeChartDataMap(Map<String, ChartData> map) {
        String key = CHART_DATA_key;
        if (reportCache != null) {
            reportCache.storeObject(key, map);
        }
    }

    public static Object getObject(String file) {
        if (reportCache != null) {
            return reportCache.getObject(file);
        }
        return null;
    }

    public static void storeObject(String file, Object obj) {
        if (reportCache != null) {
            reportCache.storeObject(file, obj);
        }
    }

    public static void setChartData(String chartId) {
        HttpServletRequest request = ServletUtil.getRequest();
        String id = request.getParameter("token") + CHART_DATA_key;
        String base64Data = request.getParameter("_base64Data");
        String prefix = "data:image/png;base64,";
        if (base64Data != null && base64Data.startsWith(prefix)) {
            base64Data = base64Data.substring(prefix.length(), base64Data.length());
        }
        Cell cell = new Cell();
        cell.setName(chartId);
        ChartData chartData = new ChartData();
        String width = request.getParameter("_width");
        String height = request.getParameter("_height");
        chartData.setBase64Data(base64Data);
        chartData.setHeight(UnitUtils.pixelToPoint(Integer.valueOf(height).intValue()));
        chartData.setWidth(UnitUtils.pixelToPoint(Integer.valueOf(width).intValue()));
        redisUtil.insertHash(id, chartId, JsonUtil.getObjectToString((Object)chartData));
        redisUtil.expire(id, 300L);
    }

    public static ReportDefinition getReportDefinition(String file) {
        return reportDefinitionCache.getReportDefinition(file);
    }

    public static void cacheReportDefinition(String file, ReportDefinition reportDefinition) {
        reportDefinitionCache.cacheReportDefinition(file, reportDefinition);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Collection reportCaches;
        Collection coll = applicationContext.getBeansOfType(ReportCache.class).values();
        for (ReportCache cache : coll) {
            if (cache.disabled()) continue;
            reportCache = cache;
            break;
        }
        reportDefinitionCache = (reportCaches = applicationContext.getBeansOfType(ReportDefinitionCache.class).values()).size() == 0 ? new DefaultMemoryReportDefinitionCache() : (ReportDefinitionCache)reportCaches.iterator().next();
    }

    static {
        CHART_DATA_key = "_chart_data_";
    }
}

