/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.build.paging;

import com.bstek.ureport.build.BindData;
import com.bstek.ureport.build.Context;
import com.bstek.ureport.build.paging.FitPagePagination;
import com.bstek.ureport.build.paging.FixRowsPagination;
import com.bstek.ureport.build.paging.Page;
import com.bstek.ureport.build.paging.Pagination;
import com.bstek.ureport.definition.PagingMode;
import com.bstek.ureport.definition.Paper;
import com.bstek.ureport.model.Cell;
import com.bstek.ureport.model.Report;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PagingBuilder {
    private static Map<PagingMode, Pagination> paginationMap = new HashMap<PagingMode, Pagination>();

    public static List<Page> buildPages(Report report) {
        Paper paper = report.getPaper();
        Pagination pagination = paginationMap.get(paper.getPagingMode());
        List<Page> pages = pagination.doPaging(report);
        PagingBuilder.computeExistPageFunctionCells(report);
        return pages;
    }

    public static void computeExistPageFunctionCells(Report report) {
        Context context = report.getContext();
        List<Cell> existPageFunctionCells = context.getExistPageFunctionCells();
        for (Cell cell : existPageFunctionCells) {
            List<BindData> dataList = context.buildCellData(cell);
            if (dataList == null || dataList.size() == 0) continue;
            BindData bindData = dataList.get(0);
            cell.setData(bindData.getValue());
            cell.setBindData(bindData.getDataList());
            cell.doFormat();
            cell.doDataWrapCompute(context);
        }
    }

    static {
        paginationMap.put(PagingMode.fitpage, new FitPagePagination());
        paginationMap.put(PagingMode.fixrows, new FixRowsPagination());
    }
}

