/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.build.paging;

import com.bstek.ureport.build.paging.BasePagination;
import com.bstek.ureport.build.paging.Page;
import com.bstek.ureport.build.paging.Pagination;
import com.bstek.ureport.definition.Band;
import com.bstek.ureport.definition.Orientation;
import com.bstek.ureport.definition.Paper;
import com.bstek.ureport.model.Report;
import com.bstek.ureport.model.Row;
import java.util.ArrayList;
import java.util.List;

public class FitPagePagination
extends BasePagination
implements Pagination {
    @Override
    public List<Page> doPaging(Report report) {
        Row row;
        Paper paper = report.getPaper();
        int height = paper.getHeight() - paper.getBottomMargin() - paper.getTopMargin() - 5;
        if (paper.getOrientation().equals(Orientation.landscape)) {
            height = paper.getWidth() - paper.getBottomMargin() - paper.getTopMargin() - 5;
        }
        List<Row> rows = report.getRows();
        List<Row> headerRows = report.getHeaderRepeatRows();
        List<Row> footerRows = report.getFooterRepeatRows();
        List<Row> titleRows = report.getTitleRows();
        List<Row> summaryRows = report.getSummaryRows();
        int repeatHeaderRowHeight = report.getRepeatHeaderRowHeight();
        int repeatFooterRowHeight = report.getRepeatFooterRowHeight();
        int titleRowHeight = report.getTitleRowsHeight();
        int rowHeight = titleRowHeight + repeatHeaderRowHeight + repeatFooterRowHeight;
        ArrayList<Page> pages = new ArrayList<Page>();
        ArrayList<Row> pageRows = new ArrayList<Row>();
        ArrayList<Row> pageRepeatHeaders = new ArrayList<Row>();
        ArrayList<Row> pageRepeatFooters = new ArrayList<Row>();
        pageRepeatHeaders.addAll(headerRows);
        pageRepeatFooters.addAll(footerRows);
        int pageIndex = 1;
        for (int i = 0; i < rows.size() && (row = rows.get(i)) != null; ++i) {
            Row nextRow;
            int rowRealHeight = row.getRealHeight();
            if (rowRealHeight == 0) continue;
            Band band = row.getBand();
            if (band != null) {
                int j;
                String rowKey = row.getRowKey();
                int index = -1;
                if (band.equals((Object)Band.headerrepeat)) {
                    for (j = 0; j < pageRepeatHeaders.size(); ++j) {
                        Row headerRow = (Row)pageRepeatHeaders.get(j);
                        if (!headerRow.getRowKey().equals(rowKey)) continue;
                        index = j;
                        break;
                    }
                    pageRepeatHeaders.remove(index);
                    pageRepeatHeaders.add(index, row);
                    continue;
                }
                if (!band.equals((Object)Band.footerrepeat)) continue;
                for (j = 0; j < pageRepeatFooters.size(); ++j) {
                    Row footerRow = (Row)pageRepeatFooters.get(j);
                    if (!footerRow.getRowKey().equals(rowKey)) continue;
                    index = j;
                    break;
                }
                pageRepeatFooters.remove(index);
                pageRepeatFooters.add(index, row);
                continue;
            }
            pageRows.add(row);
            row.setPageIndex(pageIndex);
            boolean overflow = false;
            if (i + 1 < rows.size() && (rowHeight += rowRealHeight + 1) + (nextRow = rows.get(i + 1)).getRealHeight() > height) {
                overflow = true;
            }
            if (!overflow && row.isPageBreak()) {
                overflow = true;
            }
            if (!overflow) continue;
            Page newPage = this.buildPage(pageRows, pageRepeatHeaders, pageRepeatFooters, titleRows, pageIndex, report);
            ++pageIndex;
            pages.add(newPage);
            rowHeight = repeatHeaderRowHeight + repeatFooterRowHeight;
            pageRows = new ArrayList();
        }
        if (!pageRows.isEmpty()) {
            Page newPage = this.buildPage(pageRows, pageRepeatHeaders, pageRepeatFooters, titleRows, pageIndex, report);
            pages.add(newPage);
        }
        report.getContext().setTotalPages(pages.size());
        this.buildPageHeaderFooter(pages, report);
        this.buildSummaryRows(summaryRows, pages);
        return pages;
    }
}

