/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.build.cell.right;

import com.bstek.ureport.build.cell.DuplicateType;
import com.bstek.ureport.build.cell.right.CellRightDuplicator;
import com.bstek.ureport.model.Cell;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RightDuplocatorWrapper {
    private String mainCellName;
    private List<CellRightDuplicator> mainCellChildren = new ArrayList<CellRightDuplicator>();
    private List<CellRightDuplicator> cellDuplicators = new ArrayList<CellRightDuplicator>();
    private Map<Cell, List<CellRightDuplicator>> createNewDuplicatorsMap = new HashMap<Cell, List<CellRightDuplicator>>();
    private List<Cell> duplicatorCells = new ArrayList<Cell>();

    public RightDuplocatorWrapper(String mainCellName) {
        this.mainCellName = mainCellName;
    }

    public void addCellRightDuplicator(CellRightDuplicator duplicator) {
        if (duplicator.getDuplicateType().equals((Object)DuplicateType.Duplicate)) {
            this.addCellRightDuplicatorToMap(duplicator);
        } else {
            this.cellDuplicators.add(duplicator);
            this.duplicatorCells.add(duplicator.getCell());
        }
    }

    private void addCellRightDuplicatorToMap(CellRightDuplicator duplicator) {
        Cell topParentCell = duplicator.getCell().getTopParentCell();
        if (topParentCell.getName().equals(this.mainCellName)) {
            this.mainCellChildren.add(duplicator);
        }
        List<Object> list = null;
        if (this.createNewDuplicatorsMap.containsKey(topParentCell)) {
            list = this.createNewDuplicatorsMap.get(topParentCell);
        } else {
            list = new ArrayList();
            this.createNewDuplicatorsMap.put(topParentCell, list);
        }
        list.add(duplicator);
    }

    public boolean contains(Cell cell) {
        return this.duplicatorCells.contains(cell);
    }

    public List<CellRightDuplicator> getMainCellChildren() {
        return this.mainCellChildren;
    }

    public List<CellRightDuplicator> fetchChildrenDuplicator(Cell topParentCell) {
        return this.createNewDuplicatorsMap.get(topParentCell);
    }

    public List<CellRightDuplicator> getCellDuplicators() {
        return this.cellDuplicators;
    }
}

