/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.build.cell.down;

import com.bstek.ureport.build.Context;
import com.bstek.ureport.model.Cell;
import com.bstek.ureport.model.Report;
import com.bstek.ureport.model.Row;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DownDuplicate {
    private int index;
    private Cell mainCell;
    private int rowSize;
    private Context context;
    private int minRowNumber = -1;
    private Map<Row, Row> rowMap = new HashMap<Row, Row>();
    private List<Row> newRowList = new ArrayList<Row>();

    public DownDuplicate(Cell mainCell, int rowSize, Context context) {
        this.mainCell = mainCell;
        this.rowSize = rowSize;
        this.context = context;
    }

    public Row newRow(Row row, int currentRowNumber) {
        if (this.rowMap.containsKey(row)) {
            return this.rowMap.get(row);
        }
        int rowNumber = currentRowNumber;
        Row newRow = row.newRow();
        rowNumber = rowNumber + this.rowSize * (this.index - 1) + this.rowSize;
        if (this.minRowNumber == -1 || this.minRowNumber > rowNumber) {
            this.minRowNumber = rowNumber;
        }
        newRow.setTempRowNumber(rowNumber);
        this.newRowList.add(newRow);
        this.rowMap.put(row, newRow);
        return newRow;
    }

    public Cell getMainCell() {
        return this.mainCell;
    }

    public int getRowSize() {
        return this.rowSize;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public Context getContext() {
        return this.context;
    }

    public void complete() {
        if (this.minRowNumber < 1) {
            return;
        }
        Report report = this.context.getReport();
        report.insertRows(this.minRowNumber, this.newRowList);
    }

    public void reset() {
        this.rowMap.clear();
    }
}

