/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.build.cell.down;

import com.bstek.ureport.build.Context;
import com.bstek.ureport.build.cell.down.CellDownDuplicator;
import com.bstek.ureport.build.cell.down.DownDuplicate;
import com.bstek.ureport.build.cell.down.DownDuplocatorWrapper;
import com.bstek.ureport.model.Cell;
import com.bstek.ureport.model.Row;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CellDownDuplicateUnit {
    private Cell mainCell;
    private int mainCellRowNumber;
    private Context context;
    private DownDuplicate downDuplicate;
    private DownDuplocatorWrapper downDuplocatorWrapper;

    public CellDownDuplicateUnit(Context context, DownDuplocatorWrapper downDuplocatorWrapper, Cell mainCell, int mainCellRowNumber, int rowSize) {
        this.context = context;
        this.downDuplocatorWrapper = downDuplocatorWrapper;
        this.mainCell = mainCell;
        this.mainCellRowNumber = mainCellRowNumber;
        this.downDuplicate = new DownDuplicate(mainCell, rowSize, context);
    }

    public void duplicate(Cell cell, int index) {
        HashMap<Cell, Cell> newCellMap = new HashMap<Cell, Cell>();
        newCellMap.put(this.mainCell, cell);
        this.downDuplicate.setIndex(index);
        for (CellDownDuplicator childDuplicator : this.downDuplocatorWrapper.getMainCellChildren()) {
            Cell newCell = childDuplicator.duplicateChildrenCell(this.downDuplicate, cell, this.mainCell, false);
            newCellMap.put(childDuplicator.getCell(), newCell);
            this.processChildrenCells(newCell, childDuplicator.getCell(), newCellMap, this.downDuplicate, childDuplicator.isNonChild());
            childDuplicator.setNonChild(false);
        }
        for (CellDownDuplicator cellDownDuplicator : this.downDuplocatorWrapper.getCellDuplicators()) {
            cellDownDuplicator.duplicate(this.downDuplicate, cell);
        }
        Row newRow = this.downDuplicate.newRow(cell.getRow(), this.mainCellRowNumber);
        cell.setRow(newRow);
        newRow.getCells().add(cell);
        cell.getColumn().getCells().add(cell);
        this.context.addReportCell(cell);
        this.downDuplicate.reset();
        for (Cell newCell : newCellMap.values()) {
            Cell originTopCell = newCell.getTopParentCell();
            if (originTopCell == null || !newCellMap.containsKey(originTopCell)) continue;
            newCell.setTopParentCell((Cell)newCellMap.get(originTopCell));
        }
    }

    public void complete() {
        this.downDuplicate.complete();
    }

    private void processChildrenCells(Cell cell, Cell originalCell, Map<Cell, Cell> newCellMap, DownDuplicate downDuplicate, boolean parentNonChild) {
        List<CellDownDuplicator> childCellDownDuplicators = this.downDuplocatorWrapper.fetchChildrenDuplicator(originalCell);
        if (childCellDownDuplicators == null) {
            return;
        }
        for (CellDownDuplicator duplicator : childCellDownDuplicators) {
            Cell newCell = duplicator.duplicateChildrenCell(downDuplicate, cell, originalCell, parentNonChild);
            newCellMap.put(duplicator.getCell(), newCell);
            this.processChildrenCells(newCell, duplicator.getCell(), newCellMap, downDuplicate, duplicator.isNonChild());
            duplicator.setNonChild(false);
        }
    }
}

