/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.build.aggregate;

import com.bstek.ureport.Utils;
import com.bstek.ureport.build.BindData;
import com.bstek.ureport.build.Context;
import com.bstek.ureport.build.aggregate.Aggregate;
import com.bstek.ureport.exception.ReportComputeException;
import com.bstek.ureport.expression.model.Condition;
import com.bstek.ureport.expression.model.expr.dataset.DatasetExpression;
import com.bstek.ureport.model.Cell;
import com.bstek.ureport.utils.DataUtils;
import java.util.ArrayList;
import java.util.List;

public class CountAggregate
extends Aggregate {
    @Override
    public List<BindData> aggregate(DatasetExpression expr, Cell cell, Context context) {
        ArrayList<BindData> list;
        String datasetName = expr.getDatasetName();
        Cell leftCell = DataUtils.fetchLeftCell(cell, context, datasetName);
        Cell topCell = DataUtils.fetchTopCell(cell, context, datasetName);
        List<Object> leftList = null;
        List<Object> topList = null;
        if (leftCell != null) {
            leftList = leftCell.getBindData();
        }
        if (topCell != null) {
            topList = topCell.getBindData();
        }
        int count = 0;
        if (leftList == null && topList == null) {
            List<?> data = context.getDatasetData(datasetName);
            count = this.doCondition(data, cell, expr, context);
        } else if (leftList == null) {
            count = this.doCondition(topList, cell, expr, context);
        } else if (topList == null) {
            count = this.doCondition(leftList, cell, expr, context);
        } else {
            list = null;
            Object data = null;
            String prop = null;
            if (leftList.size() > topList.size()) {
                list = topList;
                data = leftCell.getData();
                value = leftCell.getValue();
                de = DataUtils.fetchDatasetExpression(value);
                if (de == null) {
                    throw new ReportComputeException("Unsupport value : " + String.valueOf(value));
                }
                prop = de.getProperty();
            } else {
                list = leftList;
                data = topCell.getData();
                value = topCell.getValue();
                de = DataUtils.fetchDatasetExpression(value);
                if (de == null) {
                    throw new ReportComputeException("Unsupport value : " + String.valueOf(value));
                }
                prop = de.getProperty();
            }
            Condition condition = this.getCondition(cell);
            if (condition == null) {
                condition = expr.getCondition();
            }
            for (Object e : list) {
                if (condition != null && !condition.filter(cell, cell, e, context)) continue;
                Object o = Utils.getProperty(e, prop);
                if (o != null && data != null && (o == data || o.equals(data))) {
                    ++count;
                    continue;
                }
                if (o != null || data != null) continue;
                ++count;
            }
        }
        list = new ArrayList<BindData>();
        list.add(new BindData(count, null));
        return list;
    }

    private int doCondition(List<?> dataList, Cell cell, DatasetExpression expr, Context context) {
        Condition condition = this.getCondition(cell);
        if (condition == null) {
            condition = expr.getCondition();
        }
        if (condition == null) {
            return dataList.size();
        }
        int size = 0;
        for (Object obj : dataList) {
            boolean result = condition.filter(cell, cell, obj, context);
            if (!result) continue;
            ++size;
        }
        return size;
    }
}

