/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.build;

import com.bstek.ureport.model.Cell;
import com.bstek.ureport.model.Column;
import com.bstek.ureport.model.Report;
import com.bstek.ureport.model.Row;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HideRowColumnBuilder {
    public void doHideProcessColumn(Report report, Column col) {
        int colWidth = col.getWidth();
        if (colWidth > 0 || col.isHide()) {
            return;
        }
        col.setHide(true);
        List<Column> columns = report.getColumns();
        int colNumber = col.getColumnNumber();
        Map<Row, Map<Column, Cell>> cellMap = report.getRowColCellMap();
        List<Row> rows = report.getRows();
        for (Row row : rows) {
            if (row.getRealHeight() == 0) continue;
            Map<Column, Cell> rowMap = cellMap.get(row);
            if (rowMap == null) {
                return;
            }
            Cell cell = rowMap.get(col);
            if (cell != null) {
                colSpan = cell.getColSpan();
                if (colSpan > 0) {
                    if (--colSpan == 1) {
                        colSpan = 0;
                    }
                    cell.setColSpan(colSpan);
                    Column nextCol = columns.get(colNumber);
                    cell.setColumn(nextCol);
                    rowMap.put(nextCol, cell);
                }
            } else {
                cell = this.fetchPrevColumnCell(report, colNumber - 2, row);
                colSpan = cell.getColSpan();
                if (colSpan > 0) {
                    if (--colSpan == 1) {
                        colSpan = 0;
                    }
                    cell.setColSpan(colSpan);
                }
            }
            rowMap.remove(col);
        }
    }

    public void doHideProcessRow(Report report, Row row) {
        int rowHeight = row.getRealHeight();
        if (rowHeight > 0 || row.isHide()) {
            return;
        }
        row.setHide(true);
        Map<Row, Map<Column, Cell>> cellMap = report.getRowColCellMap();
        Map<Column, Cell> map = cellMap.get(row);
        if (map == null) {
            return;
        }
        List<Row> rows = report.getRows();
        List<Column> columns = report.getColumns();
        int rowNumber = row.getRowNumber();
        for (Column col : columns) {
            if (col.getWidth() == 0) continue;
            Cell cell = map.get(col);
            if (cell != null) {
                int rowSpan = cell.getRowSpan();
                if (rowSpan <= 0) continue;
                if (--rowSpan == 1) {
                    rowSpan = 0;
                }
                cell.setRowSpan(rowSpan);
                Row nextRow = rows.get(rowNumber);
                cell.setRow(nextRow);
                Map<Column, Cell> nextRowMap = cellMap.get(nextRow);
                if (nextRowMap == null) {
                    nextRowMap = new HashMap<Column, Cell>();
                    cellMap.put(nextRow, nextRowMap);
                }
                nextRowMap.put(col, cell);
                continue;
            }
            Cell prevCell = this.fetchPrevRowCell(report, rowNumber - 2, col);
            int rowSpan = prevCell.getRowSpan();
            if (rowSpan <= 0) continue;
            if (--rowSpan == 1) {
                rowSpan = 0;
            }
            prevCell.setRowSpan(rowSpan);
        }
        cellMap.remove(row);
    }

    private Cell fetchPrevColumnCell(Report report, int startColNumber, Row row) {
        Map<Row, Map<Column, Cell>> cellMap = report.getRowColCellMap();
        List<Column> columns = report.getColumns();
        Cell targetCell = null;
        Map<Column, Cell> colMap = cellMap.get(row);
        for (int i = startColNumber; i > -1; --i) {
            Column prevCol = columns.get(i);
            if (colMap != null && (targetCell = colMap.get(prevCol)) != null) break;
        }
        return targetCell;
    }

    private Cell fetchPrevRowCell(Report report, int startRowNumber, Column col) {
        Row prevRow;
        Map<Column, Cell> colMap;
        Map<Row, Map<Column, Cell>> cellMap = report.getRowColCellMap();
        List<Row> rows = report.getRows();
        Cell targetCell = null;
        for (int i = startRowNumber; i > -1 && ((colMap = cellMap.get(prevRow = rows.get(i))) == null || (targetCell = colMap.get(col)) == null); --i) {
        }
        return targetCell;
    }
}

