/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.build;

import com.bstek.ureport.build.BindData;
import com.bstek.ureport.build.Context;
import com.bstek.ureport.build.aggregate.Aggregate;
import com.bstek.ureport.build.aggregate.AvgAggregate;
import com.bstek.ureport.build.aggregate.CountAggregate;
import com.bstek.ureport.build.aggregate.CustomGroupAggregate;
import com.bstek.ureport.build.aggregate.GroupAggregate;
import com.bstek.ureport.build.aggregate.MaxAggregate;
import com.bstek.ureport.build.aggregate.MinAggregate;
import com.bstek.ureport.build.aggregate.RegroupAggregate;
import com.bstek.ureport.build.aggregate.ReselectAggregate;
import com.bstek.ureport.build.aggregate.SelectAggregate;
import com.bstek.ureport.build.aggregate.SumAggregate;
import com.bstek.ureport.definition.value.AggregateType;
import com.bstek.ureport.exception.CellComputeException;
import com.bstek.ureport.expression.model.expr.dataset.DatasetExpression;
import com.bstek.ureport.model.Cell;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DatasetUtils {
    private static Map<AggregateType, Aggregate> aggregates = new HashMap<AggregateType, Aggregate>();

    public static List<BindData> computeDatasetExpression(DatasetExpression expr, Cell cell, Context context) {
        AggregateType aggregateType = expr.getAggregate();
        Aggregate aggregate = aggregates.get((Object)aggregateType);
        if (aggregate != null) {
            return aggregate.aggregate(expr, cell, context);
        }
        throw new CellComputeException("Unknow aggregate : " + String.valueOf((Object)aggregateType));
    }

    static {
        aggregates.put(AggregateType.group, new GroupAggregate());
        aggregates.put(AggregateType.select, new SelectAggregate());
        aggregates.put(AggregateType.reselect, new ReselectAggregate());
        aggregates.put(AggregateType.regroup, new RegroupAggregate());
        aggregates.put(AggregateType.avg, new AvgAggregate());
        aggregates.put(AggregateType.count, new CountAggregate());
        aggregates.put(AggregateType.sum, new SumAggregate());
        aggregates.put(AggregateType.min, new MinAggregate());
        aggregates.put(AggregateType.max, new MaxAggregate());
        aggregates.put(AggregateType.customgroup, new CustomGroupAggregate());
    }
}

