/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport;

import com.bstek.ureport.build.Context;
import com.bstek.ureport.definition.datasource.BuildinDatasource;
import com.bstek.ureport.exception.ConvertException;
import com.bstek.ureport.exception.ReportComputeException;
import com.bstek.ureport.model.Cell;
import com.bstek.ureport.model.Report;
import com.bstek.ureport.provider.image.ImageProvider;
import java.math.BigDecimal;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class Utils
implements ApplicationContextAware {
    private static ApplicationContext applicationContext;
    private static Collection<BuildinDatasource> buildinDatasources;
    private static Collection<ImageProvider> imageProviders;
    private static boolean debug;

    public static boolean isDebug() {
        return debug;
    }

    public static void logToConsole(String msg) {
        if (debug) {
            System.out.println(msg);
        }
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public static Collection<BuildinDatasource> getBuildinDatasources() {
        return buildinDatasources;
    }

    public static Collection<ImageProvider> getImageProviders() {
        return imageProviders;
    }

    public static Connection getBuildinConnection(String name) {
        for (BuildinDatasource datasource : buildinDatasources) {
            if (!name.equals(datasource.name())) continue;
            return datasource.getConnection();
        }
        return null;
    }

    public static List<Cell> fetchTargetCells(Cell cell, Context context, String cellName) {
        while (!context.isCellPocessed(cellName)) {
            context.getReportBuilder().buildCell(context, null);
        }
        List<Cell> leftCells = Utils.fetchCellsByLeftParent(context, cell, cellName);
        List<Cell> topCells = Utils.fetchCellsByTopParent(context, cell, cellName);
        if (leftCells != null && topCells != null) {
            int leftSize = leftCells.size();
            int topSize = topCells.size();
            if (leftSize == 1 || topSize == 0) {
                return leftCells;
            }
            if (topSize == 1 || leftSize == 0) {
                return topCells;
            }
            if (leftSize == 0 && topSize == 0) {
                return new ArrayList<Cell>();
            }
            ArrayList<Cell> list = new ArrayList<Cell>();
            if (leftSize <= topSize) {
                for (Cell c : leftCells) {
                    if (!topCells.contains(c)) continue;
                    list.add(c);
                }
            } else {
                for (Cell c : topCells) {
                    if (!leftCells.contains(c)) continue;
                    list.add(c);
                }
            }
            return list;
        }
        if (leftCells != null && topCells == null) {
            return leftCells;
        }
        if (leftCells == null && topCells != null) {
            return topCells;
        }
        Report report = context.getReport();
        return report.getCellsMap().get(cellName);
    }

    private static List<Cell> fetchCellsByLeftParent(Context context, Cell cell, String cellName) {
        Cell leftParentCell = cell.getLeftParentCell();
        if (leftParentCell == null) {
            return null;
        }
        if (leftParentCell.getName().equals(cellName)) {
            ArrayList<Cell> list = new ArrayList<Cell>();
            list.add(leftParentCell);
            return list;
        }
        Map<String, List<Cell>> childrenCellsMap = leftParentCell.getRowChildrenCellsMap();
        List<Cell> targetCells = childrenCellsMap.get(cellName);
        if (targetCells != null) {
            return targetCells;
        }
        return Utils.fetchCellsByLeftParent(context, leftParentCell, cellName);
    }

    private static List<Cell> fetchCellsByTopParent(Context context, Cell cell, String cellName) {
        Cell topParentCell = cell.getTopParentCell();
        if (topParentCell == null) {
            return null;
        }
        if (topParentCell.getName().equals(cellName)) {
            ArrayList<Cell> list = new ArrayList<Cell>();
            list.add(topParentCell);
            return list;
        }
        Map<String, List<Cell>> childrenCellsMap = topParentCell.getColumnChildrenCellsMap();
        List<Cell> targetCells = childrenCellsMap.get(cellName);
        if (targetCells != null) {
            return targetCells;
        }
        return Utils.fetchCellsByTopParent(context, topParentCell, cellName);
    }

    public static Object getProperty(Object obj, String property) {
        if (obj == null) {
            return null;
        }
        try {
            if (obj instanceof Map && property.indexOf(".") == -1) {
                Map map = (Map)obj;
                return map.get(property);
            }
            return PropertyUtils.getProperty((Object)obj, (String)property);
        }
        catch (Exception ex) {
            throw new ReportComputeException(ex);
        }
    }

    public static Date toDate(Object obj) {
        if (obj instanceof Date) {
            return (Date)obj;
        }
        if (obj instanceof String) {
            SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd");
            try {
                return sd.parse(obj.toString());
            }
            catch (Exception ex) {
                sd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                try {
                    return sd.parse(obj.toString());
                }
                catch (Exception e) {
                    throw new ReportComputeException("Can not convert " + String.valueOf(obj) + " to Date.");
                }
            }
        }
        throw new ReportComputeException("Can not convert " + String.valueOf(obj) + " to Date.");
    }

    public static BigDecimal toBigDecimal(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof BigDecimal) {
            return (BigDecimal)obj;
        }
        if (obj instanceof String) {
            if (obj.toString().trim().equals("")) {
                return new BigDecimal(0);
            }
            try {
                String str = obj.toString().trim();
                return new BigDecimal(str);
            }
            catch (Exception ex) {
                throw new ConvertException("Can not convert " + String.valueOf(obj) + " to BigDecimal.");
            }
        }
        if (obj instanceof Number) {
            Number n = (Number)obj;
            return new BigDecimal(n.doubleValue());
        }
        throw new ConvertException("Can not convert " + String.valueOf(obj) + " to BigDecimal.");
    }

    public void setDebug(boolean debug) {
        Utils.debug = debug;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Utils.applicationContext = applicationContext;
        buildinDatasources = new ArrayList<BuildinDatasource>();
        buildinDatasources.addAll(applicationContext.getBeansOfType(BuildinDatasource.class).values());
        imageProviders = new ArrayList<ImageProvider>();
        imageProviders.addAll(applicationContext.getBeansOfType(ImageProvider.class).values());
    }
}

