package jnpf.socials.utils;

import cn.hutool.core.text.StrPool;
import com.alibaba.fastjson.JSONObject;
import com.xkcoding.http.config.HttpConfig;
import jnpf.socials.config.CustomAuthConfig;
import jnpf.socials.config.SocialsConfig;
import jnpf.socials.request.AuthDingTalkNewRequest;
import jnpf.socials.request.AuthWeChatEnterpriseWWQrcodeRequest;
import jnpf.socials.request.AuthWechatAppletsRequest;
import jnpf.config.ConfigValueUtil;
import jnpf.constant.MsgCode;
import jnpf.consts.RedisConst;
import jnpf.util.RedisUtil;
import jnpf.util.StringUtil;
import me.zhyd.oauth.config.AuthSource;
import me.zhyd.oauth.enums.AuthResponseStatus;
import me.zhyd.oauth.enums.scope.*;
import me.zhyd.oauth.exception.AuthException;
import me.zhyd.oauth.model.AuthResponse;
import me.zhyd.oauth.request.*;
import me.zhyd.oauth.utils.AuthScopeUtils;
import me.zhyd.oauth.utils.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.net.URLEncoder;
import java.util.Arrays;

/**
 * 流程设计
 *
 * @author JNPF开发平台组
 * @version V3.4.2
 * @copyright 引迈信息技术有限公司
 * @date 2022/7/21 12:00:56
 */
@Component
public class AuthSocialsUtil {
    @Autowired
    private SocialsConfig socialsConfig;
    @Autowired
    private ConfigValueUtil configValueUtil;

    private static RedisUtil redisUtil;
    // 针对国外平台配置代理
    private HttpConfig httpConfig = null;

    public AuthSocialsUtil() {
//        httpConfig = HttpConfig.builder()
//                .timeout(15000)
//                .proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress("127.0.0.1", 10080)))
//                .build();
    }

    /**
     * 根据配置信息获取请求对象
     *
     * @param
     * @return
     * @copyright 引迈信息技术有限公司
     * @date 2022/7/21
     */
    public AuthRequest getAuthRequest(String source, String userId, boolean isLogin, String ticket, String tenantId) {
        AuthRequest authRequest = null;
        String addUrlStr = "";
        String urlStr = configValueUtil.getApiDomain() + "/api/oauth/Login/socials?source=" + source;
        if (!isLogin) {
            urlStr = configValueUtil.getApiDomain() + "/api/oauth/Login/socials?source=" + source;
        }
        if (StringUtil.isNotEmpty(userId)) {
            addUrlStr = "&userId=" + userId;
        }
        if (StringUtil.isNotEmpty(ticket)) {
            addUrlStr = "&jnpf_ticket=" + ticket;
        }
        if (StringUtil.isNotEmpty(tenantId)) {
            addUrlStr += "&tenantId=" + tenantId;
        }
        String url = urlStr + addUrlStr;
        String platform = source.toLowerCase();
        CustomAuthConfig socialConfig = socialsConfig.getSocialMap().get(platform);
        CustomAuthConfig newSocialConfig = new CustomAuthConfig();
        BeanUtils.copyProperties(socialConfig, newSocialConfig);
        newSocialConfig.setRedirectUri(url);
        // 针对国外平台配置代理
        switch (platform) {
            //todo 官方登录api调整目前数据问题
            case "dingtalk":
                authRequest = new AuthDingTalkNewRequest(newSocialConfig);
                break;
            //todo 未申请企业
            case "qq":
                authRequest = new AuthQqRequest(newSocialConfig);
                break;
            case "wechat_open":
                newSocialConfig.setRedirectUri(URLEncoder.encode(newSocialConfig.getRedirectUri()));
                authRequest = new AuthWeChatOpenRequest(newSocialConfig);
                break;
            case "github":
                newSocialConfig.setRedirectUri(URLEncoder.encode(newSocialConfig.getRedirectUri()));
                newSocialConfig.setScopes(AuthScopeUtils.getScopes(AuthGithubScope.values()));
                if(httpConfig != null){
                    newSocialConfig.setHttpConfig(httpConfig);
                }
                authRequest = new AuthGithubRequest(newSocialConfig);
                break;
            case "wechat_enterprise":
                newSocialConfig.setRedirectUri(URLEncoder.encode(newSocialConfig.getRedirectUri()));
                authRequest = new AuthWeChatEnterpriseQrcodeRequest(newSocialConfig);
                break;
            case "wechat_enterprise_ww":
                newSocialConfig.setRedirectUri(URLEncoder.encode(newSocialConfig.getRedirectUri()));
                authRequest = new AuthWeChatEnterpriseWWQrcodeRequest(newSocialConfig);
                break;
            case "feishu":
                authRequest = new AuthFeishuRequest(newSocialConfig);
                break;
            case "baidu":
                newSocialConfig.setScopes(Arrays.asList(
                        AuthBaiduScope.BASIC.getScope(),
                        AuthBaiduScope.SUPER_MSG.getScope(),
                        AuthBaiduScope.NETDISK.getScope()
                ));
                authRequest = new AuthBaiduRequest(newSocialConfig);
                break;
            case "gitee":
                newSocialConfig.setScopes(AuthScopeUtils.getScopes(AuthGiteeScope.values()));
                authRequest = new AuthGiteeRequest(newSocialConfig);
                break;
            case "weibo":
                newSocialConfig.setScopes(Arrays.asList(
                        AuthWeiboScope.EMAIL.getScope(),
                        AuthWeiboScope.FRIENDSHIPS_GROUPS_READ.getScope(),
                        AuthWeiboScope.STATUSES_TO_ME_READ.getScope()
                ));
                authRequest = new AuthWeiboRequest(newSocialConfig);
                break;
            case "coding":
                newSocialConfig.setDomainPrefix("");
                newSocialConfig.setScopes(Arrays.asList(
                        AuthCodingScope.USER.getScope(),
                        AuthCodingScope.USER_EMAIL.getScope(),
                        AuthCodingScope.USER_PHONE.getScope()
                ));
                authRequest = new AuthCodingRequest(newSocialConfig);
                break;
            case "oschina":
                authRequest = new AuthOschinaRequest(newSocialConfig);
                break;
            case "alipay":
                // 支付宝在创建回调地址时，不允许使用localhost或者127.0.0.1，所以这儿的回调地址使用的局域网内的ip
                authRequest = new AuthAlipayRequest(newSocialConfig, newSocialConfig.getAlipayPublicKey());
                break;
            case "csdn":
                authRequest = new AuthCsdnRequest(newSocialConfig);
                break;
            case "taobao":
                authRequest = new AuthTaobaoRequest(newSocialConfig);
                break;
            case "google":
                newSocialConfig.setScopes(AuthScopeUtils.getScopes(AuthGoogleScope.USER_EMAIL, AuthGoogleScope.USER_PROFILE, AuthGoogleScope.USER_OPENID));
                if(httpConfig != null){
                    newSocialConfig.setHttpConfig(httpConfig);
                }
                authRequest = new AuthGoogleRequest(socialConfig);
                break;
            case "facebook":
                newSocialConfig.setScopes(AuthScopeUtils.getScopes(AuthFacebookScope.values()));
                if(httpConfig != null){
                    newSocialConfig.setHttpConfig(httpConfig);
                }
                authRequest = new AuthFacebookRequest(newSocialConfig);
                break;
            case "douyin":
                authRequest = new AuthDouyinRequest(newSocialConfig);
                break;
            case "linkedin":
                authRequest = new AuthLinkedinRequest(newSocialConfig);
                break;
            case "microsoft":
                newSocialConfig.setScopes(Arrays.asList(
                        AuthMicrosoftScope.USER_READ.getScope(),
                        AuthMicrosoftScope.USER_READWRITE.getScope(),
                        AuthMicrosoftScope.USER_READBASIC_ALL.getScope(),
                        AuthMicrosoftScope.USER_READ_ALL.getScope(),
                        AuthMicrosoftScope.USER_READWRITE_ALL.getScope(),
                        AuthMicrosoftScope.USER_INVITE_ALL.getScope(),
                        AuthMicrosoftScope.USER_EXPORT_ALL.getScope(),
                        AuthMicrosoftScope.USER_MANAGEIDENTITIES_ALL.getScope(),
                        AuthMicrosoftScope.FILES_READ.getScope()
                ));
                authRequest = new AuthMicrosoftRequest(newSocialConfig);
                break;
            case "mi":
                authRequest = new AuthMiRequest(newSocialConfig);
                break;
            case "toutiao":
                authRequest = new AuthToutiaoRequest(newSocialConfig);
                break;
            case "teambition":
                authRequest = new AuthTeambitionRequest(newSocialConfig);
                break;
            case "pinterest":
                if(httpConfig != null){
                    newSocialConfig.setHttpConfig(httpConfig);
                }
                authRequest = new AuthPinterestRequest(newSocialConfig);
                break;
            case "renren":
                authRequest = new AuthRenrenRequest(newSocialConfig);
                break;
            case "stack_overflow":
                authRequest = new AuthStackOverflowRequest(newSocialConfig);
                break;
            case "huawei":
                newSocialConfig.setScopes(Arrays.asList(
                        AuthHuaweiScope.BASE_PROFILE.getScope(),
                        AuthHuaweiScope.MOBILE_NUMBER.getScope(),
                        AuthHuaweiScope.ACCOUNTLIST.getScope(),
                        AuthHuaweiScope.SCOPE_DRIVE_FILE.getScope(),
                        AuthHuaweiScope.SCOPE_DRIVE_APPDATA.getScope()
                ));
                authRequest = new AuthHuaweiRequest(newSocialConfig);
                break;
            case "kujiale":
                authRequest = new AuthKujialeRequest(newSocialConfig);
                break;
            case "gitlab":
                newSocialConfig.setScopes(AuthScopeUtils.getScopes(AuthGitlabScope.values()));
                authRequest = new AuthGitlabRequest(newSocialConfig);
                break;
            case "meituan":
                authRequest = new AuthMeituanRequest(newSocialConfig);
                break;
            case "eleme":
                authRequest = new AuthElemeRequest(newSocialConfig);
                break;
//            case "mygitlab":
//                authRequest = new AuthMyGitlabRequest(AuthConfig.builder()
//                        .clientId("")
//                        .clientSecret("")
//                        .redirectUri("http://127.0.0.1:8443/oauth/callback/mygitlab")
//                        .build());
//                break;
            case "twitter":
                if(httpConfig != null){
                    newSocialConfig.setHttpConfig(httpConfig);
                }
                authRequest = new AuthTwitterRequest(newSocialConfig);
                break;
            case "wechat_mp":
                authRequest = new AuthWeChatMpRequest(newSocialConfig);
                break;
            case "aliyun":
                authRequest = new AuthAliyunRequest(newSocialConfig);
                break;
            case "xmly":
                authRequest = new AuthXmlyRequest(newSocialConfig);
                break;
            case "wechat_enterprise_web":
                authRequest = new AuthWeChatEnterpriseWebRequest(newSocialConfig);
                break;
            case "wechat_applets":
                authRequest = new AuthWechatAppletsRequest(newSocialConfig);
                break;
            default:
                break;
        }
        if (null == authRequest) {
            throw new AuthException(MsgCode.OA024.get());
        }
        return authRequest;
    }

    @Autowired
    public void setRedisUtil(RedisUtil redisUtil) {
        AuthSocialsUtil.redisUtil = redisUtil;
    }

    public static void setSuitTicket(String suitId, String ticket) {
        redisUtil.insert(RedisConst.REDIS_LOCK4J_PREFIX + "suitticket" + StrPool.COLON + suitId, ticket, 30 * 60000);
        redisUtil.remove(RedisConst.REDIS_LOCK4J_PREFIX + "suitaccesstoken" + StrPool.COLON + suitId);
    }

    public static String getSuitTicket(String suitId) {
        String key = RedisConst.REDIS_LOCK4J_PREFIX + "suitticket" + StrPool.COLON + suitId;
        return (String) redisUtil.getString(key);
    }


    public static void setSuitAccessToken(String suitId, String token) {
        redisUtil.insert(RedisConst.REDIS_LOCK4J_PREFIX + "suitaccesstoken" + StrPool.COLON + suitId, token, 120 * 60000);
    }

    public static String getSuitAccessToken(String suitId) {
        String key = RedisConst.REDIS_LOCK4J_PREFIX + "suitaccesstoken" + StrPool.COLON + suitId;
        return (String) redisUtil.getString(key);
    }

    public static JSONObject checkResponse(String response, AuthSource source) {
        JSONObject object = JSONObject.parseObject(response);
        if (object.containsKey("errcode") && object.getIntValue("errcode") != 0) {
            throw new AuthException(object.getString("errmsg"), source);
        } else {
            return object;
        }
    }

    public static AuthResponse responseError(Exception e) {
        int errorCode = AuthResponseStatus.FAILURE.getCode();
        String errorMsg = e.getMessage();
        if (e instanceof AuthException) {
            AuthException authException = ((AuthException) e);
            errorCode = authException.getErrorCode();
            if (StringUtils.isNotEmpty(authException.getErrorMsg())) {
                errorMsg = authException.getErrorMsg();
            }
        }
        return AuthResponse.builder().code(errorCode).msg(errorMsg).build();
    }

}
