package jnpf.socials.request;

import jnpf.socials.config.CustomAuthConfig;
import jnpf.socials.enums.AuthDefaultSourceNew;
import me.zhyd.oauth.cache.AuthStateCache;
import me.zhyd.oauth.utils.UrlBuilder;


/**
 * <p>
 * 企业微信服务商二维码登录
 * </p>
 *
 * @author JNPF开发平台组
 * @version V5.2.0
 * @copyright 引迈信息技术有限公司
 * @date 2025/6/5 15:40:14
 */
public class AuthWeChatEnterpriseWWQrcodeRequest extends AbstractAuthWeChatEnterpriseWWRequest {

    public AuthWeChatEnterpriseWWQrcodeRequest(CustomAuthConfig config) {
        super(config, AuthDefaultSourceNew.WECHAT_ENTERPRISE_WW_QRCODE_THIRD);
    }

    public AuthWeChatEnterpriseWWQrcodeRequest(CustomAuthConfig config, AuthStateCache authStateCache) {
        super(config, AuthDefaultSourceNew.WECHAT_ENTERPRISE_WW_QRCODE_THIRD, authStateCache);
    }

    @Override
    public String authorize(String state) {
        return UrlBuilder.fromBaseUrl(source.authorize())
                .queryParam("login_type", "ServiceApp")
                .queryParam("appid", this.config.getClientId())
                .queryParam("redirect_uri", config.getRedirectUri())
                .queryParam("state", getRealState(state))
                .build();
    }


}
