package jnpf.socials.request;

import com.alibaba.fastjson.JSONObject;
import jnpf.socials.utils.AuthSocialsUtil;
import jnpf.util.StringUtil;
import me.zhyd.oauth.cache.AuthStateCache;
import me.zhyd.oauth.config.AuthConfig;
import me.zhyd.oauth.config.AuthSource;
import me.zhyd.oauth.enums.AuthResponseStatus;
import me.zhyd.oauth.exception.AuthException;
import me.zhyd.oauth.model.AuthCallback;
import me.zhyd.oauth.model.AuthToken;
import me.zhyd.oauth.model.AuthUser;
import me.zhyd.oauth.request.AuthDefaultRequest;
import me.zhyd.oauth.utils.HttpUtils;
import me.zhyd.oauth.utils.UrlBuilder;

/**
 * <p>
 * 企业微信服务商适配器父类
 * </p>
 *
 * @author JNPF开发平台组
 * @version V5.2.0
 * @copyright 引迈信息技术有限公司
 * @date 2025/6/5 15:40:14
 */
public abstract class AbstractAuthWeChatEnterpriseWWRequest extends AuthDefaultRequest {

    public AbstractAuthWeChatEnterpriseWWRequest(AuthConfig config, AuthSource source) {
        super(config, source);
    }

    public AbstractAuthWeChatEnterpriseWWRequest(AuthConfig config, AuthSource source, AuthStateCache authStateCache) {
        super(config, source, authStateCache);
    }

    /**
     * 获取第三方应用access_token
     * @param code code码
     * @return
     */
    @Override
    protected String doGetAuthorizationCode(String code) {
        JSONObject param = new JSONObject();
        param.put("suite_id", this.config.getClientId());
        param.put("suite_secret", this.config.getClientSecret());
        param.put("suite_ticket", AuthSocialsUtil.getSuitTicket(this.config.getClientId()));
        return new HttpUtils(config.getHttpConfig()).post(source.accessToken(), param.toJSONString()).getBody();
    }

    @Override
    public AuthToken getAccessToken(AuthCallback authCallback) {
        if (StringUtil.isEmpty(AuthSocialsUtil.getSuitTicket(this.config.getClientId()))) {
            throw new AuthException("企业微信后台未推送应用SuitTicket");
        }
        String token = AuthSocialsUtil.getSuitAccessToken(this.config.getClientId());
        if (StringUtil.isEmpty(token)) {
            String response = doGetAuthorizationCode(null);
            JSONObject object = AuthSocialsUtil.checkResponse(response, this.source);
            token = object.getString("suite_access_token");
            AuthSocialsUtil.setSuitAccessToken(this.config.getClientId(), token);
        }
        return AuthToken.builder()
                .accessToken(token)
                .expireIn(0)
                .code(authCallback.getCode())
                .build();
    }

    /**
     * 获取第三方应用授权用户
     * @param authToken token
     * @return
     */
    @Override
    protected String userInfoUrl(AuthToken authToken) {
        return UrlBuilder.fromBaseUrl(source.userInfo())
                .queryParam("suite_access_token", authToken.getAccessToken())
                .queryParam("code", authToken.getCode())
                .build();
    }

    @Override
    public AuthUser getUserInfo(AuthToken authToken) {
        String response = doGetUserInfo(authToken);
        JSONObject object = AuthSocialsUtil.checkResponse(response, this.source);

        // 返回 OpenId 或其他，均代表非当前企业用户，不支持
        if (!object.containsKey("userid")) {
            throw new AuthException(AuthResponseStatus.UNIDENTIFIED_PLATFORM, source);
        }
        String userId = object.getString("userid");
        return AuthUser.builder()
                .rawUserInfo(object)
                .uuid(userId)
                .token(authToken)
                .source(source.toString())
                .build();
    }
}
