package jnpf.socials.enums;

import jnpf.implicit.request.ImplicitWeChatEnterpriseWWQrcodeRequest;
import jnpf.socials.request.AuthWeChatEnterpriseWWQrcodeRequest;
import jnpf.socials.request.AuthWechatAppletsRequest;
import me.zhyd.oauth.config.AuthSource;
import me.zhyd.oauth.request.AuthDefaultRequest;
import me.zhyd.oauth.request.AuthDingTalkRequest;

/**
 * 流程设计
 *
 * @author JNPF开发平台组
 * @version V3.4.2
 * @copyright 引迈信息技术有限公司
 * @date 2022/7/15 17:20:40
 */
public enum AuthDefaultSourceNew implements AuthSource {
    DINGTALK {

        @Override
        public String authorize() {
            return "https://login.dingtalk.com/oauth2/auth";
//            return "https://oapi.dingtalk.com/connect/sns_authorize";
        }

        @Override
        public String accessToken() {
            return "https://api.dingtalk.com/v1.0/oauth2/userAccessToken";
//            return "https://oapi.dingtalk.com/gettoken";

        }

        @Override
        public String userInfo() {
            return "https://api.dingtalk.com/v1.0/contact/users/me";
//            return "https://oapi.dingtalk.com/user/getuserinfo";
        }

        @Override
        public Class<? extends AuthDefaultRequest> getTargetClass() {
            return AuthDingTalkRequest.class;
        }
    },
    WECHAT_APPLETS {

        @Override
        public String authorize() {
            return null;
        }

        @Override
        public String accessToken() {
            return null;
        }

        @Override
        public String userInfo() {
            return "https://api.weixin.qq.com/sns/jscode2session";
        }

        @Override
        public Class<? extends AuthDefaultRequest> getTargetClass() {
            return AuthWechatAppletsRequest.class;
        }
    },
    //企业微信服务商网页授权
    WECHAT_ENTERPRISE_WW_WEB {
        public String authorize() {
            return "https://open.weixin.qq.com/connect/oauth2/authorize";
        }

        @Override
        public String accessToken() {
            return "https://qyapi.weixin.qq.com/cgi-bin/service/get_suite_token";
        }

        @Override
        public String userInfo() {
//            return "https://qyapi.weixin.qq.com/cgi-bin/service/getuserinfo3rd";
            return "https://qyapi.weixin.qq.com/cgi-bin/service/auth/getuserinfo3rd";
        }

        public Class<? extends AuthDefaultRequest> getTargetClass() {
            return ImplicitWeChatEnterpriseWWQrcodeRequest.class;
        }
    },
    //企业微信服务商扫码
    WECHAT_ENTERPRISE_WW_QRCODE_THIRD {
        @Override
        public String authorize() {
            return "https://login.work.weixin.qq.com/wwlogin/sso/login";
        }

        @Override
        public String accessToken() {
            return "https://qyapi.weixin.qq.com/cgi-bin/service/get_suite_token";
        }

        @Override
        public String userInfo() {
//            return "https://qyapi.weixin.qq.com/cgi-bin/service/getuserinfo3rd";
            return "https://qyapi.weixin.qq.com/cgi-bin/service/auth/getuserinfo3rd";
        }

        @Override
        public Class<? extends AuthDefaultRequest> getTargetClass() {
            return AuthWeChatEnterpriseWWQrcodeRequest.class;
        }
    },
    /*WECHAT_ENTERPRISE {
        public String authorize() {
            return "https://open.weixin.qq.com/connect/oauth2/authorize";
        }

        public String accessToken() {
            return "https://qyapi.weixin.qq.com/cgi-bin/gettoken";
        }

        public String userInfo() {
            return "https://qyapi.weixin.qq.com/cgi-bin/auth/getuserinfo";
        }

        public Class<? extends AuthDefaultRequest> getTargetClass() {
            return AuthDingTalkRequest.class;
        }
    },*/
    DINGTALK_ACCOUNT {

        @Override
        public String authorize() {
            return "https://oapi.dingtalk.com/connect/oauth2/sns_authorize";
        }

        @Override
        public String accessToken() {
            return "https://oapi.dingtalk.com/gettoken";
        }

        @Override
        public String userInfo() {
            return "https://oapi.dingtalk.com/topapi/v2/user/getuserinfo";
        }

        @Override
        public Class<? extends AuthDefaultRequest> getTargetClass() {
            return AuthDingTalkRequest.class;
        }
    };
    private AuthDefaultSourceNew() {
    }
}
