package jnpf.socials.config;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.util.*;
import java.util.stream.Collectors;


/**
 * 流程设计
 *
 * @author JNPF开发平台组
 * @version V3.4.2
 * @copyright 引迈信息技术有限公司
 * @date 2022/9/6 14:58:23
 */
@Component
@ConfigurationProperties(prefix = SocialsConfig.PREFIX)
public class SocialsConfig {
    public static final String PREFIX = "socials";

    private boolean socialsEnabled = false;

    private List<CustomAuthConfig> config;

    private Map<String, CustomAuthConfig> socialMap;

    public SocialsConfig() {
    }

    public SocialsConfig(List<CustomAuthConfig> config, Map<String, CustomAuthConfig> socialMap) {
        this.config = config;
        this.socialMap = socialMap.entrySet().stream()
                .filter(item -> item.getValue().isEnabled())
                .collect(Collectors.toMap(
                        Map.Entry::getKey,
                        Map.Entry::getValue,
                        (oldValue, newValue) -> oldValue,
                        LinkedHashMap::new
                ));
    }

    public boolean isSocialsEnabled() {
        return socialsEnabled;
    }

    public void setSocialsEnabled(boolean socialsEnabled) {
        this.socialsEnabled = socialsEnabled;
    }

    public void setConfig(List<CustomAuthConfig> config) {
        this.config = config;
        this.socialMap = new HashMap<>();
        config.stream().forEach(item -> {
            this.socialMap.put(item.getProvider(), item);
        });
    }

    public List<CustomAuthConfig> getConfig() {
        return config;
    }

    public Map<String, CustomAuthConfig> getSocialMap() {
        return socialMap;
    }

    @Deprecated
    public static class Config {
        private String provider;
        private String clientId;
        private String clientSecret;
        private String agentId;
        //企业ID
        private String corpId;
        //企微应用登录类型
        //ServiceApp：服务商登录；CorpApp：企业自建/代开发应用登录
        private String loginType;

        public Config() {
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            Config config = (Config) o;
            return Objects.equals(provider, config.provider) && Objects.equals(clientId, config.clientId) && Objects.equals(clientSecret, config.clientSecret) && Objects.equals(agentId, config.agentId);
        }

        @Override
        public int hashCode() {
            return Objects.hash(provider, clientId, clientSecret, agentId);
        }

        @Override
        public String toString() {
            return "Config{" +
                    "provider='" + provider + '\'' +
                    ", clientId='" + clientId + '\'' +
                    ", clientSecret='" + clientSecret + '\'' +
                    ", agentId='" + agentId + '\'' +
                    ", corpId='" + corpId + '\'' +
                    ", loginType='" + loginType + '\'' +
                    '}';
        }

        public String getProvider() {
            return provider;
        }

        public void setProvider(String provider) {
            this.provider = provider;
        }

        public String getClientId() {
            return clientId;
        }

        public void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public String getClientSecret() {
            return clientSecret;
        }

        public void setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
        }

        public String getAgentId() {
            return agentId;
        }

        public String getCorpId() {
            return corpId;
        }

        public void setCorpId(String corpId) {
            this.corpId = corpId;
        }

        public String getLoginType() {
            return loginType;
        }

        public void setLoginType(String loginType) {
            this.loginType = loginType;
        }

        public void setAgentId(String agentId) {
            this.agentId = agentId;
        }

        public Config(String provider, String clientId, String clientSecret, String agentId) {
            this.provider = provider;
            this.clientId = clientId;
            this.clientSecret = clientSecret;
            this.agentId = agentId;
        }
    }

}
