package jnpf.socials.config;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;
import me.zhyd.oauth.config.AuthConfig;

/**
 * <p>
 * 自定义第三方授权配置
 * </p>
 *
 * @author JNPF开发平台组
 * @version V5.2.0
 * @copyright 引迈信息技术有限公司
 * @date 2025/6/5 15:40:14
 */
@Getter
@Setter
@Accessors(chain = true)
@NoArgsConstructor
@AllArgsConstructor
public class CustomAuthConfig extends AuthConfig {

    /**
     * 平台
     */
    private String provider;

    /**
     * 是否启用
     */
    private boolean enabled;

    /**
     * 企业微信服务商应用id 用于网页授权登录 扫码登录ID填写到clientId
     */
    private String appClientId;

    /**
     * 企业微信服务商应用Secret 用于网页授权登录 扫码登录Secret填写到clientSecret
     */
    private String appClientSecret;

    /* 用于官网快速配置 */
    /**
     * 企业ID
     */
    private String corpId;
    /**
     * 企业微信服务商扫码登录应用消息配置TOKEN
     */
    private String clientToken;
    /**
     * 企业微信服务商扫码登录应用消息配置EncodingAESKey
     */
    private String clientEncodingAesKey;
    /**
     * 企业微信服务商授权登录应用消息配置TOKEN
     */
    private String appClientToken;
    /**
     * 企业微信服务商授权登录应用消息配置EncodingAESKey
     */
    private String appClientEncodingAesKey;

}
