package jnpf.implicit.utils;

import jnpf.implicit.request.ImplicitDingTalkRequest;
import jnpf.implicit.request.ImplicitWeChatEnterpriseWWQrcodeRequest;
import jnpf.socials.config.CustomAuthConfig;
import jnpf.socials.config.SocialsConfig;
import jnpf.socials.model.AuthCallbackNew;
import jnpf.config.ConfigValueUtil;
import jnpf.constant.MsgCode;
import jnpf.exception.LoginException;
import jnpf.util.StringUtil;
import me.zhyd.oauth.enums.AuthResponseStatus;
import me.zhyd.oauth.exception.AuthException;
import me.zhyd.oauth.model.AuthResponse;
import me.zhyd.oauth.model.AuthUser;
import me.zhyd.oauth.request.AuthRequest;
import me.zhyd.oauth.request.AuthWeChatEnterpriseWebRequest;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.net.URLEncoder;

/**
 * 免登工具类
 *
 * @author JNPF开发平台组
 * @version v5.0.0
 * @copyright 引迈信息技术有限公司
 * @date 2024/5/23 11:09:26
 */
@Component
public class ImplicitLoginUtil {
    @Autowired
    private SocialsConfig socialsConfig;
    @Autowired
    private ConfigValueUtil configValueUtil;

    public String getAuthLink(String source) {
        AuthRequest authRequest = this.getAuthRequest(source, null, null);
        return authRequest.authorize(null);
    }

    public String loginByCode(String source, String code, String state) {
        //获取第三方请求
        AuthCallbackNew callback = new AuthCallbackNew();
        callback.setAuthCode(code);
        callback.setAuth_code(code);
        callback.setAuthorization_code(code);
        callback.setCode(code);
        callback.setState(state);
        AuthRequest authRequest = this.getAuthRequest(source, null, null);
        AuthResponse<AuthUser> res = authRequest.login(callback);
        if (AuthResponseStatus.FAILURE.getCode() == res.getCode()) {
            throw new LoginException("连接失败！");
        } else if (AuthResponseStatus.SUCCESS.getCode() != res.getCode()) {
            throw new LoginException("授权失败:" + res.getMsg());
        }
        //登录用户第三方id
        return getSocialUuid(res);
    }

    private String getSocialUuid(AuthResponse<AuthUser> res) {
        String uuid = res.getData().getUuid();
        if (res.getData().getToken() != null && StringUtil.isNotEmpty(res.getData().getToken().getUnionId())) {
            uuid = res.getData().getToken().getUnionId();
        }
        return uuid;
    }

    /**
     * 根据配置信息获取请求对象
     *
     * @param
     * @return
     * @copyright 引迈信息技术有限公司
     * @date 2022/7/21
     */
    public AuthRequest getAuthRequest(String source, String userId, String tenantId) {
        AuthRequest authRequest = null;
        String url = configValueUtil.getApiDomain() + "/api/oauth/Login/implicit?source=" + source;
        String platform = source.toLowerCase();
        CustomAuthConfig socialConfig = socialsConfig.getSocialMap().get(platform);
        CustomAuthConfig newSocialConfig = new CustomAuthConfig();
        BeanUtils.copyProperties(socialConfig, newSocialConfig);
        newSocialConfig.setRedirectUri(url);
        switch (source.toLowerCase()) {
            case "dingtalk":
                newSocialConfig.setRedirectUri(URLEncoder.encode(newSocialConfig.getRedirectUri()));
                newSocialConfig.setIgnoreCheckState(true);
                authRequest = new ImplicitDingTalkRequest(newSocialConfig);
                break;
            case "wechat_enterprise":
                newSocialConfig.setRedirectUri(URLEncoder.encode(newSocialConfig.getRedirectUri()));
                authRequest = new AuthWeChatEnterpriseWebRequest(newSocialConfig);
                break;
            case "wechat_enterprise_ww":
                newSocialConfig.setRedirectUri(URLEncoder.encode(newSocialConfig.getRedirectUri()));
                authRequest = new ImplicitWeChatEnterpriseWWQrcodeRequest(newSocialConfig);
                break;
            default:
                break;
        }
        if (null == authRequest) {
            throw new AuthException(MsgCode.OA024.get());
        }
        return authRequest;
    }
}
