package jnpf.implicit.request;

import jnpf.socials.config.CustomAuthConfig;
import jnpf.socials.enums.AuthDefaultSourceNew;
import jnpf.socials.request.AbstractAuthWeChatEnterpriseWWRequest;
import me.zhyd.oauth.cache.AuthStateCache;
import me.zhyd.oauth.utils.UrlBuilder;

/**
 * <p>
 * 企业微信服务商网页授权登录
 * </p>
 *
 * @author JNPF开发平台组
 * @version 5.2.0
 * @copyright 引迈信息技术有限公司
 * @date 2025/6/5 15:40:14
 */
public class ImplicitWeChatEnterpriseWWQrcodeRequest extends AbstractAuthWeChatEnterpriseWWRequest {

    public ImplicitWeChatEnterpriseWWQrcodeRequest(CustomAuthConfig config) {
        super(config, AuthDefaultSourceNew.WECHAT_ENTERPRISE_WW_WEB);
        config.setClientId(config.getAppClientId());
        config.setClientSecret(config.getAppClientSecret());
    }

    public ImplicitWeChatEnterpriseWWQrcodeRequest(CustomAuthConfig config, AuthStateCache authStateCache) {
        super(config, AuthDefaultSourceNew.WECHAT_ENTERPRISE_WW_WEB, authStateCache);
        config.setClientId(config.getAppClientId());
        config.setClientSecret(config.getAppClientSecret());
    }


    @Override
    public String authorize(String state) {
        return UrlBuilder.fromBaseUrl(this.source.authorize())
                .queryParam("appid", this.config.getClientId())
                .queryParam("redirect_uri", this.config.getRedirectUri())
                .queryParam("response_type", "code")
                .queryParam("scope", "snsapi_base")
                .queryParam("state", getRealState(state).concat("#wechat_redirect"))
                .build();
    }


}
