package jnpf.filter;

import com.baomidou.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import jnpf.database.util.LogicDeleteHelper;
import jnpf.database.util.NotTenantPluginHolder;
import jnpf.database.util.TenantDataSourceUtil;
import jnpf.util.TenantProvider;
import jnpf.util.UserProvider;
import org.springframework.core.annotation.Order;
import org.springframework.web.filter.OncePerRequestFilter;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * 线程缓存清理
 */
@Order(-99)
public class ClearThreadContextFilter extends OncePerRequestFilter {


    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        try {
            filterChain.doFilter(request, response);
        }finally {
            //清除线程缓存
            UserProvider.clearLocalUser();
            TenantProvider.clearBaseSystemIfo();
            TenantDataSourceUtil.clearLocalTenantInfo();
            DynamicDataSourceContextHolder.clear();
            NotTenantPluginHolder.clearNotSwitchFlag();
            LogicDeleteHelper.clearIgnoreLogicDelete();
            LogicDeleteHelper.clearDeleteAction();
        }
    }

}
