package jnpf.i18n.config;

import jakarta.annotation.Resource;
import jnpf.event.ProjectEventListener;
import jnpf.i18n.constant.I18nConst;
import jnpf.i18n.provider.MyI18nMessageProvider;
import jnpf.module.ProjectEventInstance;
import org.springframework.context.annotation.Configuration;


/**
 * 国际化语言Redis缓存监听配置
 * 收到租户多语言缓存变动时清空租户多语言缓存
 */
@Configuration(proxyBeanMethods = false)
public class I18nRefreshListenerConfig {

    @Resource
    private MyI18nMessageProvider myI18nMessageProvider;

    @ProjectEventListener(channelRegex = {I18nConst.CACHE_KEY_SERVER + ".*", I18nConst.CACHE_KEY_FRONT + ".*"})
//    @ProjectEventListener(channelSpel = {"#root.channel.startsWith(T(jnpf.i18n.constant.I18nConst).CACHE_KEY_SERVER) || #root.channel.startsWith(T(jnpf.i18n.constant.I18nConst).CACHE_KEY_FRONT)"})
    public void onRedisKeySetEvent(ProjectEventInstance redisEvent){
        String key = redisEvent.getChannel();
        // 获取多租户编码
        key = key.replace(I18nConst.CACHE_KEY_SERVER, "").replace(I18nConst.CACHE_KEY_FRONT, "");
        myI18nMessageProvider.removeTenantCache(key);
    }

}
