package jnpf.module;

import lombok.experimental.Accessors;

/**
 * 自定义事件内部存在事务流转模型
 */
@Accessors(chain = true)
public class ProjectEventPublishTransaction extends ProjectEvent {

    public ProjectEventPublishTransaction(Long eventId, String topic, String channel, Object source, Integer messageModel, boolean async, boolean afterCommitTransaction) {
        super(eventId, topic, channel, source, messageModel, async, afterCommitTransaction);
    }

    public static ProjectEventPublishTransaction parseEvent(ProjectEvent event){
        return new ProjectEventPublishTransaction(event.getEventId()
                , event.getToptic(), event.getChannel(), event.getSource()
                , event.getMessageModel(), event.isAsync(), event.isAfterCommitTransaction());
    }
}
