package jnpf.module;

import lombok.experimental.Accessors;

/**
 * 自定义事件内部无事务流转模型
 */
@Accessors(chain = true)
public class ProjectEventPublish extends ProjectEvent{

    public ProjectEventPublish(Long eventId, String topic, String channel, Object source, Integer messageModel, boolean async, boolean afterCommitTransaction) {
        super(eventId, topic, channel, source, messageModel, async, afterCommitTransaction);
    }

    public static ProjectEventPublish parseEvent(ProjectEvent event){
        return new ProjectEventPublish(event.getEventId()
                , event.getToptic(), event.getChannel(), event.getSource()
                , event.getMessageModel(), event.isAsync(), event.isAfterCommitTransaction());
    }
}
