package jnpf.event;

import jnpf.consts.ProjectEventConst;
import org.springframework.context.event.EventListener;

import java.lang.annotation.*;

/**
 * 自定义事件处理器注解
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
@Documented
@Inherited
public @interface ProjectEventListener {

    String toptic() default ProjectEventConst.DEFAULT_TOPIC_NAME;

    /**
     * 直接匹配
     */
    String[] channel() default {};

    /**
     * 正则匹配
     */
    String[] channelRegex() default {};

    /**
     * SpELl表达式匹配, 结果必须boolean类型
     * @see EventListener#condition()
     */
    String[] channelSpel() default {};

}
