package jnpf.consts;

/**
 * 自定义事件常量
 */
public class ProjectEventConst {

    public static final String DEFAULT_TOPIC_NAME = "defMsgToptic";



    /**
     * 自定义通知渠道 Redis
     */
    public static final String EVENT_PUBLISH_TYPE_REDIS = "redis";
    /**
     * 自定义通知渠道 MQ
     */
    public static final String EVENT_PUBLISH_TYPE_QUEUE = "mq";




    /**
     * Redis事件监听模式， 当前DB
     */
    public static final String REDIS_PUBLISH_TYPE_CURRENT = "current";

    /**
     * Redis事件监听模式， 相同Redis(全部DB) 多个环境使用相同的Redis实例都会触发事件
     */
    public static final String REDIS_PUBLISH_TYPE_ALL = "all";

    /**
     * Redis事件消息监听前缀
     */
    public static final String DEFAULT_CHANNEL_PREFIX = "myevent_";



    /**
     * 集群消费, 只有一个服务消费成功
     */
    public static final int EVENT_PUBLISH_MODEL_CLUSTERING = 1;

    /**
     * 广播消费, 所有服务都可以消费
     */
    public static final int EVENT_PUBLISH_MODEL_BROADCASTING = 2;

    /**
     * 本地消息, 只在当前进程触发事件
     */
    public static final int EVENT_PUBLISH_MODEL_LOCAL = 3;
}
