package jnpf.service;

import jnpf.base.UserInfo;
import jnpf.exception.LoginException;
import jnpf.model.BaseSystemInfo;
import jnpf.model.login.PcUserVO;

/**
 * 登陆业务层
 *
 * @author JNPF开发平台组
 * @version V3.1.0
 * @copyright 引迈信息技术有限公司（https://www.jnpfsoft.com）
 * @date 2021-03-23
 */
public interface LoginService {

    /**
     * 租戶登录验证
     *
     * @param userInfo
     * @return userAccount, tenantId, tenandDb
     * @throws LoginException
     */
    UserInfo getTenantAccount(UserInfo userInfo) throws LoginException;

    /**
     * 生成用户登录信息
     *
     * @param userInfo      账户信息
     * @param sysConfigInfo 系统配置
     * @return
     * @throws LoginException
     */
    UserInfo userInfo(UserInfo userInfo, BaseSystemInfo sysConfigInfo) throws LoginException;

    /**
     * 获取用户登陆信息
     *
     * @return
     */
    PcUserVO getCurrentUser(String type, String systemCode, Integer isBackend);

    /**
     * 修改密码信息发送
     *
     * @return
     */
    void updatePasswordMessage();

    /**
     * @param tenantId
     * @return
     */
    BaseSystemInfo getBaseSystemConfig(String tenantId);


}
