package jnpf.granter;

import jnpf.consts.AuthConsts;
import jnpf.service.UserDetailService;
import org.springframework.stereotype.Component;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 *
 * @author JNPF开发平台组
 * @copyright 引迈信息技术有限公司
 */
@Component
public class UserDetailsServiceBuilder {


    private final Map<String, UserDetailService> userDetailServices = new ConcurrentHashMap<>();

    public UserDetailsServiceBuilder(Map<String, UserDetailService> userDetailServices) {
        userDetailServices.forEach(this.userDetailServices::put);
    }


    /**
     * 根据类型获取合适的UserDetailService
     * @param detailType
     * @return
     */
    public UserDetailService getUserDetailService(String detailType){
        if(detailType == null){
            detailType = AuthConsts.USERDETAIL_ACCOUNT;
        }
        return userDetailServices.get(detailType);
    }

}
