package jnpf.consts;

import lombok.AllArgsConstructor;
import lombok.Getter;


/**
 *
 * @author JNPF开发平台组
 * @copyright 引迈信息技术有限公司
 */
@Getter
@AllArgsConstructor
public enum LoginTicketStatus {

    /**
     * 登录成功
     */
    Success(1),
    /**
     * 未登录
     */
    UnLogin(2),
    /**
     * 登录失败
     */
    ErrLogin(3),
    /**
     * 未绑定
     */
    UnBind(4),
    /**
     * 失效
     */
    Invalid(5),
    /**
     * 多租户
     */
    Multitenancy(6),
    /**
     * 第三方账号未绑定账号，请绑定后重试
     */
    UnBindMes(7),;

    private int status;
}
