package jnpf.config;
import lombok.Data;
import org.springframework.beans.factory.annotation.Value;


/**
 *
 * @author JNPF开发平台组
 * @copyright 引迈信息技术有限公司
 */
@Data
public class JnpfOauthConfig {

    public static final String PREFIX = "oauth";

    /**
     * 服务器域名
     * @see ConfigValueUtil#getApiDomain()
     */
    @Deprecated
    @Value("${config.ApiDomain:}")
    private String jnpfDomain;


    /**
     * 开启单点登录, 需额外代码支持
     */
    private Boolean ssoEnabled = false;

    /**
     * 后端登录完整路径路径
     */
    private String loginPath;

    /**
     * 默认发起的登录协议
     */
    private String defaultSSO = "cas";

    /**
     * 轮询Ticket有效期, 秒
     */
    private long ticketTimeout = 60;

    /**
     * pc端服务器域名
     * @see ConfigValueUtil#getFrontDomain()
     */
    @Deprecated
    @Value("${config.FrontDomain:}")
    private String jnpfFrontDomain;

    /**
     * app端服务器域名
     * @see ConfigValueUtil#getAppDomain()
     */
    @Deprecated
    @Value("${config.AppDomain:}")
    private String jnpfAppDomain;

}
