package jnpf.service;

import com.unfbx.chatgpt.entity.chat.Message;
import jnpf.model.ai.AiFormModel;

import java.util.List;


/**
 * AI服务工具
 * @author JNPF开发平台组
 * @copyright 引迈信息技术有限公司
 * @date 2024/10/9 14:38
 */
public interface OpenAiService {

    /**
     * 简单对话
     * @param prompt
     */
    String completion(String prompt);

    /**
     * 连续对话
     * @param messages 历史对话内容
     */
    String completion(Message... messages);

    /**
     * 生成表单
     * @param businessName 业务名称
     * @return
     */
    String generatorModelStr(String businessName);

    /**
     * 生成表单
     * @param prompt
     * @return
     */
    List<AiFormModel> generatorModelVO(String prompt);
}
