package jnpf.selenium.properties;

import jnpf.selenium.consts.SeleniumConsts;
import lombok.Data;

import java.time.Duration;

@Data
public class SeleniumProperties {

    /**
     * 浏览器类型
     */
    private String browserType = SeleniumConsts.BROWSER_TYPE_CHROME;

    /**
     * 浏览器路径
     */
    private String browserPath;

    /**
     * 浏览器驱动路径
     */
    private String driverPath;

    /**
     * 页面加载超时时间
     */
    private Duration pageLoadTimeout = Duration.ofSeconds(30L);


    /**
     * 查找元素超时时间
     */
    private Duration implicaitlyWaitTimeout = Duration.ofSeconds(30L);


    /**
     * 执行脚本超时时间
     */
    private Duration scriptTimeout = Duration.ofSeconds(30L);

}
