package jnpf.selenium.autoconfiguration;

import jnpf.selenium.SeleniumHelper;
import jnpf.selenium.consts.SeleniumConsts;
import jnpf.selenium.driver.ChromeBrowser;
import jnpf.selenium.properties.SeleniumProperties;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.*;

@Configuration(proxyBeanMethods = false)
@Import(SeleniumHelper.class)
@Slf4j
public class SeleniumAutoConfiguration {

    @Bean
    @ConfigurationProperties(SeleniumConsts.SELENIUM)
    public SeleniumProperties getSeleniumProperties() {
        return new SeleniumProperties();
    }

    @Lazy
    @ConditionalOnMissingBean(name = SeleniumConsts.BROWSER_BEAN_PREFIX + SeleniumConsts.BROWSER_TYPE_CHROME)
    @Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
    @Bean(value = SeleniumConsts.BROWSER_BEAN_PREFIX + SeleniumConsts.BROWSER_TYPE_CHROME, initMethod = "init", destroyMethod = "close")
    public ChromeBrowser getChromeBrowser() {
        if(log.isDebugEnabled()){
            log.debug(SeleniumConsts.MARKER, "Init New Chrome");
        }
        return new ChromeBrowser();
    }
}
