package jnpf.selenium;

import jnpf.selenium.consts.SeleniumConsts;
import jnpf.selenium.driver.SeleniumBrowser;
import jnpf.selenium.properties.SeleniumProperties;
import lombok.Getter;
import lombok.Setter;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods = false)
public class SeleniumHelper implements ApplicationContextAware {

    private static ApplicationContext applicationContext;

    @Getter
    @Setter
    private static SeleniumProperties seleniumProperties;


    public static <T extends SeleniumBrowser<?, ?, ?>> T getBrowser() {
        SeleniumBrowser<?, ?, ?> seleniumBrowser = (SeleniumBrowser<?, ?, ?>) applicationContext.getBean(SeleniumConsts.BROWSER_BEAN_PREFIX + seleniumProperties.getBrowserType());
        return (T) seleniumBrowser;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        SeleniumHelper.applicationContext = applicationContext;
        SeleniumHelper.seleniumProperties =applicationContext.getBean(SeleniumProperties.class);
    }
}
