package jnpf.permissions;

import cn.dev33.satoken.SaManager;
import cn.dev33.satoken.session.SaSession;
import cn.dev33.satoken.stp.StpInterface;
import cn.dev33.satoken.stp.StpUtil;
import com.alibaba.fastjson.JSONObject;
import jnpf.base.UserInfo;
import jnpf.model.BaseSystemInfo;
import jnpf.properties.SecurityProperties;
import jnpf.util.StringUtil;
import jnpf.util.TenantHolder;
import jnpf.util.TenantProvider;
import jnpf.util.UserProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.*;

import static jnpf.util.Constants.ADMIN_KEY;


/**
 * 权限认证接口实现
 *
 * @author JNPF开发平台组
 * @copyright 引迈信息技术有限公司
 */
@Component
public class PermissionInterfaceImpl implements StpInterface {

    public static final String PERMISSION_KEY = "user_permission";
    public static final String ROLE_KEY = "user_roles";
    public static final String COLUMN_KEY = "user_columns";
    public static final String FORM_KEY = "user_forms";
    public static final String OTHER_PERMISSION = "permission:";
    public static final String USER_AUTH = "user_auth";

    @Autowired
    private SecurityProperties securityProperties;

    @Override
    public List<String> getPermissionList(Object loginId, String loginType) {
        if (!securityProperties.isEnablePreAuth()) {
            return Collections.emptyList();
        }
        return getListByType(PERMISSION_KEY);
    }

    @Override
    public List<String> getRoleList(Object loginId, String loginType) {
        if (!securityProperties.isEnablePreAuth()) {
            return Collections.emptyList();
        }
        return getListByType(ROLE_KEY);
    }

    public static Map<String, Object> getColumnMap() {
        return getMapByType(COLUMN_KEY);
    }

    public static Map<String, Object> getFormMap() {
        return getMapByType(FORM_KEY);
    }

    //
//    public static void setAuthorityList(String userAccount, Set<String> authority, BaseSystemInfo baseSystemInfo) {
//        userAccount = UserProvider.splicingLoginId(userAccount);
//        try {
//            TenantProvider.setBaseSystemInfo(baseSystemInfo);
//            StpUtil.getSessionByLoginId(userAccount, true).set(PERMISSION_KEY, new ArrayList<>(authority));
//        } finally {
//            TenantProvider.clearBaseSystemIfo();
//        }
//    }
//
//    public static void setRoleList(String userAccount, Set<String> role, BaseSystemInfo baseSystemInfo) {
//        userAccount = UserProvider.splicingLoginId(userAccount);
//        try {
//            TenantProvider.setBaseSystemInfo(baseSystemInfo);
//            StpUtil.getSessionByLoginId(userAccount, true).set(ROLE_KEY, new ArrayList<>(role));
//        } finally {
//            TenantProvider.clearBaseSystemIfo();
//        }
//    }
//
//
//    public static void setColumnMap(String userAccount, Map<String, List<Map<String, Object>>> columnList, BaseSystemInfo baseSystemInfo) {
//        userAccount = UserProvider.splicingLoginId(userAccount);
//        try {
//            TenantProvider.setBaseSystemInfo(baseSystemInfo);
//            StpUtil.getSessionByLoginId(userAccount, true).set(COLUMN_KEY, columnList);
//        } finally {
//            TenantProvider.clearBaseSystemIfo();
//        }
//    }
//
//    public static void setFormMap(String userAccount, Map<String, List<Map<String, Object>>> formList, BaseSystemInfo baseSystemInfo) {
//        userAccount = UserProvider.splicingLoginId(userAccount);
//        try {
//            TenantProvider.setBaseSystemInfo(baseSystemInfo);
//            StpUtil.getSessionByLoginId(userAccount, true).set(FORM_KEY, formList);
//        } finally {
//            TenantProvider.clearBaseSystemIfo();
//        }
//    }
    public static void setMap(String userAccount, String sysId, Map<String, List<Map<String, Object>>> columnsMap, Map<String, List<Map<String, Object>>> formMap) {
        userAccount = UserProvider.splicingLoginId(userAccount);
        String tenantId = TenantHolder.getDatasourceId();
        Map<String, Object> map = getMap();
        Map<String, Object> mapRes = new HashMap<>(map);
        Map<String, Object> mapAuth = new HashMap<>();
        if (map.containsKey(sysId)) {
            mapAuth = (Map<String, Object>) map.get(sysId);
        }
        if (!columnsMap.isEmpty()) {
            mapAuth.put(PermissionInterfaceImpl.COLUMN_KEY, columnsMap);
        }
        if (!formMap.isEmpty()) {
            mapAuth.put(PermissionInterfaceImpl.FORM_KEY, formMap);
        }
        mapRes.put(sysId, mapAuth);
        SaManager.getSaTokenDao().set(OTHER_PERMISSION + tenantId + "_" + userAccount, JSONObject.toJSONString(mapRes), 60 * 60 * 24);
    }

    public static Map<String, Object> getMap() {
        UserInfo userInfo = UserProvider.getUser();
        String account = userInfo.getIsAdministrator() ? ADMIN_KEY : userInfo.getUserId();
        account = UserProvider.splicingLoginId(account);
        String tenantId = TenantHolder.getDatasourceId();
        String json = SaManager.getSaTokenDao().get(OTHER_PERMISSION + tenantId + "_" + account);
        if (StringUtil.isEmpty(json)) {
            return Collections.emptyMap();
        }
        return JSONObject.parseObject(json);
    }

    private static Map<String, Object> getMapByType(String typeKey) {
        Map<String, Object> map = getMap();
        Map<String, Object> res = new HashMap<>();
        for (String key : map.keySet()) {
            Map<String, Object> obj = (Map<String, Object>) map.get(key);
            if (obj != null && obj.containsKey(typeKey)) {
                res.putAll((Map<String, Object>) obj.get(typeKey));
            }
        }
        return res;
    }

    /**
     * 添加系统权限map
     * map(系统id，和全部权限map)
     *
     * @param userAccount
     * @param baseSystemInfo
     */
    public static void setUserAuth(String userAccount, String sysId, Set<String> authorityList, Set<String> roleAuthorityList, BaseSystemInfo baseSystemInfo) {
        userAccount = UserProvider.splicingLoginId(userAccount);
        try {
            TenantProvider.setBaseSystemInfo(baseSystemInfo);
            Map<String, Object> map = PermissionInterfaceImpl.getUserAuth();
            Map<String, Object> mapRes = new HashMap<>(map);
            Map<String, Object> mapAuth = new HashMap<>();
            if (map.containsKey(sysId)) {
                mapAuth = (Map<String, Object>) map.get(sysId);
            }
            if (!authorityList.isEmpty()) {
                mapAuth.put(PermissionInterfaceImpl.PERMISSION_KEY, authorityList);
            }
            if (!roleAuthorityList.isEmpty()) {
                mapAuth.put(PermissionInterfaceImpl.ROLE_KEY, roleAuthorityList);
            }
            mapRes.put(sysId, mapAuth);
            StpUtil.getSessionByLoginId(userAccount, true).set(USER_AUTH, mapRes);
        } finally {
            TenantProvider.clearBaseSystemIfo();
        }
    }

    public static Map<String, Object> getUserAuth() {
        UserInfo userInfo = UserProvider.getUser();
        String account = userInfo.getIsAdministrator() ? ADMIN_KEY : userInfo.getUserId();
        account = UserProvider.splicingLoginId(account);
        SaSession saSession = StpUtil.getSessionByLoginId(account, false);
        if (saSession == null) {
            return Collections.emptyMap();
        }
        return saSession.get(USER_AUTH, Collections.emptyMap());
    }

    private static List<String> getListByType(String typeKey) {
        Map<String, Object> userAuth = PermissionInterfaceImpl.getUserAuth();
        List<String> list = new ArrayList<>();
        if (userAuth != null) {
            for (String key : userAuth.keySet()) {
                Map<String, Object> obj = (Map<String, Object>) userAuth.get(key);
                if (obj != null && obj.containsKey(typeKey)) {
                    list.addAll((Set<String>) obj.get(typeKey));
                }
            }
        }
        return list;
    }
}
