package jnpf.config;

import jnpf.consts.RedisConst;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;


/**
 * Redis 监听配置
 */
@Configuration(proxyBeanMethods = false)
public class RedisListenerConfig {

    @Bean
    public RedisConst getRedisConst(RedisProperties redisProperties){
        return new RedisConst(redisProperties);
    }


    @Bean
    public RedisMessageListenerContainer container(RedisConnectionFactory connectionFactory) {
        RedisMessageListenerContainer container = new RedisMessageListenerContainer();
        container.setConnectionFactory(connectionFactory);
        return container;
    }

}
