package jnpf.event;

import jnpf.module.ProjectEvent;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;

import java.util.Objects;
import java.util.function.Predicate;

/**
 * 事件匹配
 */
public class ProjectEventKeyMatcher {


    protected String expression;

    public ProjectEventKeyMatcher(String expression) {
        this.expression = expression;
    }

    public Predicate<ProjectEvent> getMatcher() {
        return null;
    }

    protected String getExpression() {
        return expression;
    }

    public boolean isMatch(ProjectEvent event){
        return getMatcher().test(event);
    }

    /**
     * 文本直接匹配
     */
    public static class Text extends ProjectEventKeyMatcher {

        public Text(String expression) {
            super(expression);
        }

        private final Predicate<ProjectEvent> matcher = target -> Objects.equals(target.getChannel(), getExpression());

        @Override
        public Predicate<ProjectEvent> getMatcher() {
            return matcher;
        }
    }


    /**
     * 正则匹配 String.matches匹配
     */
    public static class Pattern extends ProjectEventKeyMatcher {

        public Pattern(String expression) {
            super(expression);
        }

        private final Predicate<ProjectEvent> matcher = target -> target.getChannel().matches(expression);

        @Override
        public Predicate<ProjectEvent> getMatcher() {
            return matcher;
        }
    }

    /**
     * SpEL表达式匹配
     */
    public static class Spel extends ProjectEventKeyMatcher {

        private static final ExpressionParser spelExpressionParserarser = new SpelExpressionParser();

        public Spel(String expression) {
            super(expression);
        }

        private final Predicate<ProjectEvent> matcher = target -> {
            Expression expression1 = spelExpressionParserarser.parseExpression(expression);
            return Boolean.TRUE.equals(expression1.getValue(target, Boolean.TYPE));
        };

        @Override
        public Predicate<ProjectEvent> getMatcher() {
            return matcher;
        }
    }


}
