package jnpf.config;

import jnpf.constants.AiConstants;
import lombok.Data;

import java.time.Duration;
import java.util.List;

/**
 * AI 配置
 *
 * @author JNPF开发平台组
 * @copyright 引迈信息技术有限公司
 * @date 2024/10/9 14:03
 */
@Data
public class AiProperties {

    /**
     * 是否启用
     */
    private boolean enabled;

    /**
     * openai服务器
     */
    private String apiHost = AiConstants.OPENAI_HOST;

    /**
     * openai key
     */
    private List<String> apiKey;

    /**
     * 超时时间
     */
    private Long timeout = 30L;

    /**
     * 每个用户限制时间内的请求次数
     */
    private Integer userLimitCount = 1;

    /**
     * 每个用户限制时间频率
     */
    private Duration userLimitTime = Duration.ofSeconds(3);

    /**
     * 全部请求限制时间内的请求次数
     */
    private Integer totalLimitCount = 500;

    /**
     * 全部请求限制时间频率
     */
    private Duration totalLimitTime = Duration.ofMinutes(1L);

    /**
     * 代理配置
     */
    private Proxy proxy = new Proxy();

    /**
     * 对话配置
     */
    private ChatOption chat = new ChatOption();




    @Data
    public class ChatOption{

        /**
         * @see AiConstants.Model
         */
        private String mode = AiConstants.Model.QWEN_25_3;

        /**
         * 设置seed参数会使文本生成过程更具有确定性，通常用于使模型每次运行的结果一致。
         * 在每次模型调用时传入相同的seed值（由您指定），并保持其他参数不变，模型将很可能返回相同的结果。
         */
        private Integer seed = 1234;

        /**
         * 允许模型生成的最大Token数。
         */
        private Integer maxTokens = 1500;

        /**
         * 核采样的概率阈值，用于控制模型生成文本的多样性。
         * top_p越高，生成的文本更多样。反之，生成的文本更确定。
         * 由于temperature与top_p均可以控制生成文本的多样性，因此建议您只设置其中一个值。
         */
        private Double topP = 0.8;

        /**
         * 采样温度，用于控制模型生成文本的多样性。
         * temperature越高，生成的文本更多样，反之，生成的文本更确定。
         * 由于temperature与top_p均可以控制生成文本的多样性，因此建议您只设置其中一个值。
         */
        private Double temperature = 0.85;

        private boolean enableSearch = true;

    }


    @Data
    public class Proxy{
        /**
         * HTTP, SOCKS
         */
        private java.net.Proxy.Type type = java.net.Proxy.Type.HTTP;
        /**
         * 代理域名
         */
        private String host;
        /**
         * 代理端口
         */
        private Integer port;
        /**
         * 代理用户名
         */
        private String username;
        /**
         * 代理密码
         */
        private String password;
    }

}
