/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode.decoder;

import com.google.zxing.ChecksumException;
import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.DecoderResult;
import com.google.zxing.common.reedsolomon.GenericGF;
import com.google.zxing.common.reedsolomon.ReedSolomonDecoder;
import com.google.zxing.common.reedsolomon.ReedSolomonException;
import com.google.zxing.qrcode.decoder.BitMatrixParser;
import com.google.zxing.qrcode.decoder.DataBlock;
import com.google.zxing.qrcode.decoder.DecodedBitStreamParser;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.google.zxing.qrcode.decoder.QRCodeDecoderMetaData;
import com.google.zxing.qrcode.decoder.Version;
import java.util.Map;

public final class Decoder {
    private final ReedSolomonDecoder rsDecoder = new ReedSolomonDecoder(GenericGF.QR_CODE_FIELD_256);

    public DecoderResult decode(boolean[][] image) throws ChecksumException, FormatException {
        return this.decode(image, null);
    }

    public DecoderResult decode(boolean[][] image, Map<DecodeHintType, ?> hints) throws ChecksumException, FormatException {
        return this.decode(BitMatrix.parse(image), hints);
    }

    public DecoderResult decode(BitMatrix bits) throws ChecksumException, FormatException {
        return this.decode(bits, null);
    }

    public DecoderResult decode(BitMatrix bits, Map<DecodeHintType, ?> hints) throws FormatException, ChecksumException {
        BitMatrixParser parser = new BitMatrixParser(bits);
        FormatException fe = null;
        ChecksumException ce = null;
        try {
            return this.decode(parser, hints);
        }
        catch (FormatException e) {
            fe = e;
        }
        catch (ChecksumException e) {
            ce = e;
        }
        try {
            parser.remask();
            parser.setMirror(true);
            parser.readVersion();
            parser.readFormatInformation();
            parser.mirror();
            DecoderResult result = this.decode(parser, hints);
            result.setOther(new QRCodeDecoderMetaData(true));
            return result;
        }
        catch (ChecksumException | FormatException e) {
            if (fe != null) {
                throw fe;
            }
            throw ce;
        }
    }

    private DecoderResult decode(BitMatrixParser parser, Map<DecodeHintType, ?> hints) throws FormatException, ChecksumException {
        Version version = parser.readVersion();
        ErrorCorrectionLevel ecLevel = parser.readFormatInformation().getErrorCorrectionLevel();
        byte[] codewords = parser.readCodewords();
        DataBlock[] dataBlocks = DataBlock.getDataBlocks(codewords, version, ecLevel);
        int totalBytes = 0;
        DataBlock[] dataBlockArray = dataBlocks;
        int n = dataBlocks.length;
        int n2 = 0;
        while (n2 < n) {
            DataBlock dataBlock = dataBlockArray[n2];
            totalBytes += dataBlock.getNumDataCodewords();
            ++n2;
        }
        byte[] resultBytes = new byte[totalBytes];
        int resultOffset = 0;
        DataBlock[] dataBlockArray2 = dataBlocks;
        int n3 = dataBlocks.length;
        int n4 = 0;
        while (n4 < n3) {
            DataBlock dataBlock = dataBlockArray2[n4];
            byte[] codewordBytes = dataBlock.getCodewords();
            int numDataCodewords = dataBlock.getNumDataCodewords();
            this.correctErrors(codewordBytes, numDataCodewords);
            int i = 0;
            while (i < numDataCodewords) {
                resultBytes[resultOffset++] = codewordBytes[i];
                ++i;
            }
            ++n4;
        }
        return DecodedBitStreamParser.decode(resultBytes, version, ecLevel, hints);
    }

    private void correctErrors(byte[] codewordBytes, int numDataCodewords) throws ChecksumException {
        int numCodewords = codewordBytes.length;
        int[] codewordsInts = new int[numCodewords];
        int i = 0;
        while (i < numCodewords) {
            codewordsInts[i] = codewordBytes[i] & 0xFF;
            ++i;
        }
        try {
            this.rsDecoder.decode(codewordsInts, codewordBytes.length - numDataCodewords);
        }
        catch (ReedSolomonException ignored) {
            throw ChecksumException.getChecksumInstance();
        }
        i = 0;
        while (i < numDataCodewords) {
            codewordBytes[i] = (byte)codewordsInts[i];
            ++i;
        }
    }
}

