/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.ResultMetadataType;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitArray;
import com.google.zxing.oned.UPCEANReader;
import java.util.EnumMap;
import java.util.Map;

final class UPCEANExtension5Support {
    private static final int[] CHECK_DIGIT_ENCODINGS = new int[]{24, 20, 18, 17, 12, 6, 3, 10, 9, 5};
    private final int[] decodeMiddleCounters = new int[4];
    private final StringBuilder decodeRowStringBuffer = new StringBuilder();

    UPCEANExtension5Support() {
    }

    Result decodeRow(int rowNumber, BitArray row, int[] extensionStartRange) throws NotFoundException {
        StringBuilder result = this.decodeRowStringBuffer;
        result.setLength(0);
        int end = this.decodeMiddle(row, extensionStartRange, result);
        String resultString = result.toString();
        Map<ResultMetadataType, Object> extensionData = UPCEANExtension5Support.parseExtensionString(resultString);
        Result extensionResult = new Result(resultString, null, new ResultPoint[]{new ResultPoint((float)(extensionStartRange[0] + extensionStartRange[1]) / 2.0f, rowNumber), new ResultPoint(end, rowNumber)}, BarcodeFormat.UPC_EAN_EXTENSION);
        if (extensionData != null) {
            extensionResult.putAllMetadata(extensionData);
        }
        return extensionResult;
    }

    private int decodeMiddle(BitArray row, int[] startRange, StringBuilder resultString) throws NotFoundException {
        int[] counters = this.decodeMiddleCounters;
        counters[0] = 0;
        counters[1] = 0;
        counters[2] = 0;
        counters[3] = 0;
        int end = row.getSize();
        int rowOffset = startRange[1];
        int lgPatternFound = 0;
        int x = 0;
        while (x < 5 && rowOffset < end) {
            int bestMatch = UPCEANReader.decodeDigit(row, counters, rowOffset, UPCEANReader.L_AND_G_PATTERNS);
            resultString.append((char)(48 + bestMatch % 10));
            int[] nArray = counters;
            int n = counters.length;
            int n2 = 0;
            while (n2 < n) {
                int counter = nArray[n2];
                rowOffset += counter;
                ++n2;
            }
            if (bestMatch >= 10) {
                lgPatternFound |= 1 << 4 - x;
            }
            if (x != 4) {
                rowOffset = row.getNextSet(rowOffset);
                rowOffset = row.getNextUnset(rowOffset);
            }
            ++x;
        }
        if (resultString.length() != 5) {
            throw NotFoundException.getNotFoundInstance();
        }
        int checkDigit = UPCEANExtension5Support.determineCheckDigit(lgPatternFound);
        if (UPCEANExtension5Support.extensionChecksum(resultString.toString()) != checkDigit) {
            throw NotFoundException.getNotFoundInstance();
        }
        return rowOffset;
    }

    private static int extensionChecksum(CharSequence s) {
        int length = s.length();
        int sum = 0;
        int i = length - 2;
        while (i >= 0) {
            sum += s.charAt(i) - 48;
            i -= 2;
        }
        sum *= 3;
        i = length - 1;
        while (i >= 0) {
            sum += s.charAt(i) - 48;
            i -= 2;
        }
        return (sum *= 3) % 10;
    }

    private static int determineCheckDigit(int lgPatternFound) throws NotFoundException {
        int d = 0;
        while (d < 10) {
            if (lgPatternFound == CHECK_DIGIT_ENCODINGS[d]) {
                return d;
            }
            ++d;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static Map<ResultMetadataType, Object> parseExtensionString(String raw) {
        if (raw.length() != 5) {
            return null;
        }
        String value = UPCEANExtension5Support.parseExtension5String(raw);
        if (value == null) {
            return null;
        }
        EnumMap<ResultMetadataType, Object> result = new EnumMap<ResultMetadataType, Object>(ResultMetadataType.class);
        result.put(ResultMetadataType.SUGGESTED_PRICE, value);
        return result;
    }

    private static String parseExtension5String(String raw) {
        String currency;
        switch (raw.charAt(0)) {
            case '0': {
                currency = "\u62e2";
                break;
            }
            case '5': {
                currency = "$";
                break;
            }
            case '9': {
                switch (raw) {
                    case "90000": {
                        return null;
                    }
                    case "99991": {
                        return "0.00";
                    }
                    case "99990": {
                        return "Used";
                    }
                }
                currency = "";
                break;
            }
            default: {
                currency = "";
            }
        }
        int rawAmount = Integer.parseInt(raw.substring(1));
        String unitsString = String.valueOf(rawAmount / 100);
        int hundredths = rawAmount % 100;
        String hundredthsString = hundredths < 10 ? "0" + hundredths : String.valueOf(hundredths);
        return String.valueOf(currency) + unitsString + '.' + hundredthsString;
    }
}

