/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.config;

import java.util.ArrayList;
import java.util.concurrent.Executor;
import org.springframework.context.annotation.Bean;
import org.springframework.messaging.Message;
import org.springframework.messaging.converter.ByteArrayMessageConverter;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.messaging.converter.DefaultContentTypeResolver;
import org.springframework.messaging.converter.MappingJackson2MessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.converter.StringMessageConverter;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.messaging.simp.annotation.support.SimpAnnotationMethodMessageHandler;
import org.springframework.messaging.simp.broker.AbstractBrokerMessageHandler;
import org.springframework.messaging.simp.broker.SimpleBrokerMessageHandler;
import org.springframework.messaging.simp.config.ChannelRegistration;
import org.springframework.messaging.simp.config.MessageBrokerRegistry;
import org.springframework.messaging.simp.config.TaskExecutorRegistration;
import org.springframework.messaging.simp.stomp.StompBrokerRelayMessageHandler;
import org.springframework.messaging.simp.user.DefaultUserDestinationResolver;
import org.springframework.messaging.simp.user.DefaultUserSessionRegistry;
import org.springframework.messaging.simp.user.UserDestinationMessageHandler;
import org.springframework.messaging.simp.user.UserDestinationResolver;
import org.springframework.messaging.simp.user.UserSessionRegistry;
import org.springframework.messaging.support.AbstractSubscribableChannel;
import org.springframework.messaging.support.ExecutorSubscribableChannel;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.util.ClassUtils;
import org.springframework.util.MimeTypeUtils;

public abstract class AbstractMessageBrokerConfiguration {
    private static final boolean jackson2Present = ClassUtils.isPresent((String)"com.fasterxml.jackson.databind.ObjectMapper", (ClassLoader)AbstractMessageBrokerConfiguration.class.getClassLoader());
    private ChannelRegistration clientInboundChannelRegistration;
    private ChannelRegistration clientOutboundChannelRegistration;
    private MessageBrokerRegistry brokerRegistry;
    private static final AbstractBrokerMessageHandler noopBroker = new AbstractBrokerMessageHandler(null){

        @Override
        protected void startInternal() {
        }

        @Override
        protected void stopInternal() {
        }

        @Override
        protected void handleMessageInternal(Message<?> message) {
        }
    };

    protected AbstractMessageBrokerConfiguration() {
    }

    @Bean
    public AbstractSubscribableChannel clientInboundChannel() {
        ExecutorSubscribableChannel channel = new ExecutorSubscribableChannel((Executor)this.clientInboundChannelExecutor());
        ChannelRegistration r = this.getClientInboundChannelRegistration();
        if (r.hasInterceptors()) {
            channel.setInterceptors(r.getInterceptors());
        }
        return channel;
    }

    @Bean
    public ThreadPoolTaskExecutor clientInboundChannelExecutor() {
        TaskExecutorRegistration r = this.getClientInboundChannelRegistration().getTaskExecutorRegistration();
        ThreadPoolTaskExecutor executor = r != null ? r.getTaskExecutor() : new ThreadPoolTaskExecutor();
        executor.setThreadNamePrefix("clientInboundChannel-");
        return executor;
    }

    protected final ChannelRegistration getClientInboundChannelRegistration() {
        if (this.clientInboundChannelRegistration == null) {
            ChannelRegistration registration = new ChannelRegistration();
            this.configureClientInboundChannel(registration);
            this.clientInboundChannelRegistration = registration;
        }
        return this.clientInboundChannelRegistration;
    }

    protected abstract void configureClientInboundChannel(ChannelRegistration var1);

    @Bean
    public AbstractSubscribableChannel clientOutboundChannel() {
        ExecutorSubscribableChannel channel = new ExecutorSubscribableChannel((Executor)this.clientOutboundChannelExecutor());
        ChannelRegistration r = this.getClientOutboundChannelRegistration();
        if (r.hasInterceptors()) {
            channel.setInterceptors(r.getInterceptors());
        }
        return channel;
    }

    @Bean
    public ThreadPoolTaskExecutor clientOutboundChannelExecutor() {
        TaskExecutorRegistration r = this.getClientOutboundChannelRegistration().getTaskExecutorRegistration();
        ThreadPoolTaskExecutor executor = r != null ? r.getTaskExecutor() : new ThreadPoolTaskExecutor();
        executor.setThreadNamePrefix("clientOutboundChannel-");
        return executor;
    }

    protected final ChannelRegistration getClientOutboundChannelRegistration() {
        if (this.clientOutboundChannelRegistration == null) {
            ChannelRegistration registration = new ChannelRegistration();
            this.configureClientOutboundChannel(registration);
            this.clientOutboundChannelRegistration = registration;
        }
        return this.clientOutboundChannelRegistration;
    }

    protected abstract void configureClientOutboundChannel(ChannelRegistration var1);

    @Bean
    public AbstractSubscribableChannel brokerChannel() {
        ChannelRegistration r = this.getBrokerRegistry().getBrokerChannelRegistration();
        ExecutorSubscribableChannel channel = r.hasTaskExecutor() ? new ExecutorSubscribableChannel() : new ExecutorSubscribableChannel((Executor)this.brokerChannelExecutor());
        if (r.hasInterceptors()) {
            channel.setInterceptors(r.getInterceptors());
        }
        return channel;
    }

    @Bean
    public ThreadPoolTaskExecutor brokerChannelExecutor() {
        TaskExecutorRegistration r = this.getBrokerRegistry().getBrokerChannelRegistration().getTaskExecutorRegistration();
        ThreadPoolTaskExecutor executor = r != null ? r.getTaskExecutor() : new ThreadPoolTaskExecutor();
        executor.setThreadNamePrefix("brokerChannel-");
        return executor;
    }

    protected final MessageBrokerRegistry getBrokerRegistry() {
        if (this.brokerRegistry == null) {
            MessageBrokerRegistry registry = new MessageBrokerRegistry(this.clientInboundChannel(), this.clientOutboundChannel());
            this.configureMessageBroker(registry);
            this.brokerRegistry = registry;
        }
        return this.brokerRegistry;
    }

    protected abstract void configureMessageBroker(MessageBrokerRegistry var1);

    @Bean
    public SimpAnnotationMethodMessageHandler simpAnnotationMethodMessageHandler() {
        SimpAnnotationMethodMessageHandler handler = new SimpAnnotationMethodMessageHandler(this.clientInboundChannel(), this.clientOutboundChannel(), this.brokerMessagingTemplate());
        handler.setDestinationPrefixes(this.getBrokerRegistry().getApplicationDestinationPrefixes());
        handler.setMessageConverter(this.brokerMessageConverter());
        return handler;
    }

    @Bean
    public AbstractBrokerMessageHandler simpleBrokerMessageHandler() {
        SimpleBrokerMessageHandler handler = this.getBrokerRegistry().getSimpleBroker(this.brokerChannel());
        return handler != null ? handler : noopBroker;
    }

    @Bean
    public AbstractBrokerMessageHandler stompBrokerRelayMessageHandler() {
        StompBrokerRelayMessageHandler handler = this.getBrokerRegistry().getStompBrokerRelay(this.brokerChannel());
        return handler != null ? handler : noopBroker;
    }

    @Bean
    public UserDestinationMessageHandler userDestinationMessageHandler() {
        UserDestinationMessageHandler handler = new UserDestinationMessageHandler(this.clientInboundChannel(), this.clientOutboundChannel(), this.brokerChannel(), this.userDestinationResolver());
        return handler;
    }

    @Bean
    public SimpMessagingTemplate brokerMessagingTemplate() {
        SimpMessagingTemplate template = new SimpMessagingTemplate(this.brokerChannel());
        String prefix = this.getBrokerRegistry().getUserDestinationPrefix();
        if (prefix != null) {
            template.setUserDestinationPrefix(prefix);
        }
        template.setMessageConverter(this.brokerMessageConverter());
        return template;
    }

    @Bean
    public CompositeMessageConverter brokerMessageConverter() {
        DefaultContentTypeResolver contentTypeResolver = new DefaultContentTypeResolver();
        ArrayList<MessageConverter> converters = new ArrayList<MessageConverter>();
        if (jackson2Present) {
            converters.add(new MappingJackson2MessageConverter());
            contentTypeResolver.setDefaultMimeType(MimeTypeUtils.APPLICATION_JSON);
        }
        converters.add(new StringMessageConverter());
        converters.add(new ByteArrayMessageConverter());
        return new CompositeMessageConverter(converters, contentTypeResolver);
    }

    @Bean
    public UserDestinationResolver userDestinationResolver() {
        DefaultUserDestinationResolver resolver = new DefaultUserDestinationResolver(this.userSessionRegistry());
        String prefix = this.getBrokerRegistry().getUserDestinationPrefix();
        if (prefix != null) {
            resolver.setUserDestinationPrefix(prefix);
        }
        return resolver;
    }

    @Bean
    public UserSessionRegistry userSessionRegistry() {
        return new DefaultUserSessionRegistry();
    }
}

