/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode.encoder;

import com.google.zxing.WriterException;
import com.google.zxing.common.BitArray;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.google.zxing.qrcode.decoder.Version;
import com.google.zxing.qrcode.encoder.ByteMatrix;
import com.google.zxing.qrcode.encoder.MaskUtil;
import com.google.zxing.qrcode.encoder.QRCode;

final class MatrixUtil {
    private static final int[][] POSITION_DETECTION_PATTERN;
    private static final int[][] POSITION_ADJUSTMENT_PATTERN;
    private static final int[][] POSITION_ADJUSTMENT_PATTERN_COORDINATE_TABLE;
    private static final int[][] TYPE_INFO_COORDINATES;
    private static final int VERSION_INFO_POLY = 7973;
    private static final int TYPE_INFO_POLY = 1335;
    private static final int TYPE_INFO_MASK_PATTERN = 21522;

    static {
        int[][] nArrayArray = new int[7][];
        nArrayArray[0] = new int[]{1, 1, 1, 1, 1, 1, 1};
        int[] nArray = new int[7];
        nArray[0] = 1;
        nArray[6] = 1;
        nArrayArray[1] = nArray;
        int[] nArray2 = new int[7];
        nArray2[0] = 1;
        nArray2[2] = 1;
        nArray2[3] = 1;
        nArray2[4] = 1;
        nArray2[6] = 1;
        nArrayArray[2] = nArray2;
        int[] nArray3 = new int[7];
        nArray3[0] = 1;
        nArray3[2] = 1;
        nArray3[3] = 1;
        nArray3[4] = 1;
        nArray3[6] = 1;
        nArrayArray[3] = nArray3;
        int[] nArray4 = new int[7];
        nArray4[0] = 1;
        nArray4[2] = 1;
        nArray4[3] = 1;
        nArray4[4] = 1;
        nArray4[6] = 1;
        nArrayArray[4] = nArray4;
        int[] nArray5 = new int[7];
        nArray5[0] = 1;
        nArray5[6] = 1;
        nArrayArray[5] = nArray5;
        nArrayArray[6] = new int[]{1, 1, 1, 1, 1, 1, 1};
        POSITION_DETECTION_PATTERN = nArrayArray;
        int[][] nArrayArray2 = new int[5][];
        nArrayArray2[0] = new int[]{1, 1, 1, 1, 1};
        int[] nArray6 = new int[5];
        nArray6[0] = 1;
        nArray6[4] = 1;
        nArrayArray2[1] = nArray6;
        int[] nArray7 = new int[5];
        nArray7[0] = 1;
        nArray7[2] = 1;
        nArray7[4] = 1;
        nArrayArray2[2] = nArray7;
        int[] nArray8 = new int[5];
        nArray8[0] = 1;
        nArray8[4] = 1;
        nArrayArray2[3] = nArray8;
        nArrayArray2[4] = new int[]{1, 1, 1, 1, 1};
        POSITION_ADJUSTMENT_PATTERN = nArrayArray2;
        POSITION_ADJUSTMENT_PATTERN_COORDINATE_TABLE = new int[][]{{-1, -1, -1, -1, -1, -1, -1}, {6, 18, -1, -1, -1, -1, -1}, {6, 22, -1, -1, -1, -1, -1}, {6, 26, -1, -1, -1, -1, -1}, {6, 30, -1, -1, -1, -1, -1}, {6, 34, -1, -1, -1, -1, -1}, {6, 22, 38, -1, -1, -1, -1}, {6, 24, 42, -1, -1, -1, -1}, {6, 26, 46, -1, -1, -1, -1}, {6, 28, 50, -1, -1, -1, -1}, {6, 30, 54, -1, -1, -1, -1}, {6, 32, 58, -1, -1, -1, -1}, {6, 34, 62, -1, -1, -1, -1}, {6, 26, 46, 66, -1, -1, -1}, {6, 26, 48, 70, -1, -1, -1}, {6, 26, 50, 74, -1, -1, -1}, {6, 30, 54, 78, -1, -1, -1}, {6, 30, 56, 82, -1, -1, -1}, {6, 30, 58, 86, -1, -1, -1}, {6, 34, 62, 90, -1, -1, -1}, {6, 28, 50, 72, 94, -1, -1}, {6, 26, 50, 74, 98, -1, -1}, {6, 30, 54, 78, 102, -1, -1}, {6, 28, 54, 80, 106, -1, -1}, {6, 32, 58, 84, 110, -1, -1}, {6, 30, 58, 86, 114, -1, -1}, {6, 34, 62, 90, 118, -1, -1}, {6, 26, 50, 74, 98, 122, -1}, {6, 30, 54, 78, 102, 126, -1}, {6, 26, 52, 78, 104, 130, -1}, {6, 30, 56, 82, 108, 134, -1}, {6, 34, 60, 86, 112, 138, -1}, {6, 30, 58, 86, 114, 142, -1}, {6, 34, 62, 90, 118, 146, -1}, {6, 30, 54, 78, 102, 126, 150}, {6, 24, 50, 76, 102, 128, 154}, {6, 28, 54, 80, 106, 132, 158}, {6, 32, 58, 84, 110, 136, 162}, {6, 26, 54, 82, 110, 138, 166}, {6, 30, 58, 86, 114, 142, 170}};
        int[][] nArrayArray3 = new int[15][];
        int[] nArray9 = new int[2];
        nArray9[0] = 8;
        nArrayArray3[0] = nArray9;
        nArrayArray3[1] = new int[]{8, 1};
        nArrayArray3[2] = new int[]{8, 2};
        nArrayArray3[3] = new int[]{8, 3};
        nArrayArray3[4] = new int[]{8, 4};
        nArrayArray3[5] = new int[]{8, 5};
        nArrayArray3[6] = new int[]{8, 7};
        nArrayArray3[7] = new int[]{8, 8};
        nArrayArray3[8] = new int[]{7, 8};
        nArrayArray3[9] = new int[]{5, 8};
        nArrayArray3[10] = new int[]{4, 8};
        nArrayArray3[11] = new int[]{3, 8};
        nArrayArray3[12] = new int[]{2, 8};
        nArrayArray3[13] = new int[]{1, 8};
        int[] nArray10 = new int[2];
        nArray10[1] = 8;
        nArrayArray3[14] = nArray10;
        TYPE_INFO_COORDINATES = nArrayArray3;
    }

    private MatrixUtil() {
    }

    static void clearMatrix(ByteMatrix matrix) {
        matrix.clear((byte)-1);
    }

    static void buildMatrix(BitArray dataBits, ErrorCorrectionLevel ecLevel, Version version, int maskPattern, ByteMatrix matrix) throws WriterException {
        MatrixUtil.clearMatrix(matrix);
        MatrixUtil.embedBasicPatterns(version, matrix);
        MatrixUtil.embedTypeInfo(ecLevel, maskPattern, matrix);
        MatrixUtil.maybeEmbedVersionInfo(version, matrix);
        MatrixUtil.embedDataBits(dataBits, maskPattern, matrix);
    }

    static void embedBasicPatterns(Version version, ByteMatrix matrix) throws WriterException {
        MatrixUtil.embedPositionDetectionPatternsAndSeparators(matrix);
        MatrixUtil.embedDarkDotAtLeftBottomCorner(matrix);
        MatrixUtil.maybeEmbedPositionAdjustmentPatterns(version, matrix);
        MatrixUtil.embedTimingPatterns(matrix);
    }

    static void embedTypeInfo(ErrorCorrectionLevel ecLevel, int maskPattern, ByteMatrix matrix) throws WriterException {
        BitArray typeInfoBits = new BitArray();
        MatrixUtil.makeTypeInfoBits(ecLevel, maskPattern, typeInfoBits);
        int i = 0;
        while (i < typeInfoBits.getSize()) {
            int y2;
            int x2;
            boolean bit = typeInfoBits.get(typeInfoBits.getSize() - 1 - i);
            int[] coordinates = TYPE_INFO_COORDINATES[i];
            int x1 = coordinates[0];
            int y1 = coordinates[1];
            matrix.set(x1, y1, bit);
            if (i < 8) {
                x2 = matrix.getWidth() - i - 1;
                y2 = 8;
                matrix.set(x2, y2, bit);
            } else {
                x2 = 8;
                y2 = matrix.getHeight() - 7 + (i - 8);
                matrix.set(x2, y2, bit);
            }
            ++i;
        }
    }

    static void maybeEmbedVersionInfo(Version version, ByteMatrix matrix) throws WriterException {
        if (version.getVersionNumber() < 7) {
            return;
        }
        BitArray versionInfoBits = new BitArray();
        MatrixUtil.makeVersionInfoBits(version, versionInfoBits);
        int bitIndex = 17;
        int i = 0;
        while (i < 6) {
            int j = 0;
            while (j < 3) {
                boolean bit = versionInfoBits.get(bitIndex);
                --bitIndex;
                matrix.set(i, matrix.getHeight() - 11 + j, bit);
                matrix.set(matrix.getHeight() - 11 + j, i, bit);
                ++j;
            }
            ++i;
        }
    }

    static void embedDataBits(BitArray dataBits, int maskPattern, ByteMatrix matrix) throws WriterException {
        int bitIndex = 0;
        int direction = -1;
        int x = matrix.getWidth() - 1;
        int y = matrix.getHeight() - 1;
        while (x > 0) {
            if (x == 6) {
                --x;
            }
            while (y >= 0 && y < matrix.getHeight()) {
                int i = 0;
                while (i < 2) {
                    int xx = x - i;
                    if (MatrixUtil.isEmpty(matrix.get(xx, y))) {
                        boolean bit;
                        if (bitIndex < dataBits.getSize()) {
                            bit = dataBits.get(bitIndex);
                            ++bitIndex;
                        } else {
                            bit = false;
                        }
                        if (maskPattern != -1 && MaskUtil.getDataMaskBit(maskPattern, xx, y)) {
                            bit = !bit;
                        }
                        matrix.set(xx, y, bit);
                    }
                    ++i;
                }
                y += direction;
            }
            direction = -direction;
            y += direction;
            x -= 2;
        }
        if (bitIndex != dataBits.getSize()) {
            throw new WriterException("Not all bits consumed: " + bitIndex + '/' + dataBits.getSize());
        }
    }

    static int findMSBSet(int value) {
        return 32 - Integer.numberOfLeadingZeros(value);
    }

    static int calculateBCHCode(int value, int poly) {
        if (poly == 0) {
            throw new IllegalArgumentException("0 polynomial");
        }
        int msbSetInPoly = MatrixUtil.findMSBSet(poly);
        value <<= msbSetInPoly - 1;
        while (MatrixUtil.findMSBSet(value) >= msbSetInPoly) {
            value ^= poly << MatrixUtil.findMSBSet(value) - msbSetInPoly;
        }
        return value;
    }

    static void makeTypeInfoBits(ErrorCorrectionLevel ecLevel, int maskPattern, BitArray bits) throws WriterException {
        if (!QRCode.isValidMaskPattern(maskPattern)) {
            throw new WriterException("Invalid mask pattern");
        }
        int typeInfo = ecLevel.getBits() << 3 | maskPattern;
        bits.appendBits(typeInfo, 5);
        int bchCode = MatrixUtil.calculateBCHCode(typeInfo, 1335);
        bits.appendBits(bchCode, 10);
        BitArray maskBits = new BitArray();
        maskBits.appendBits(21522, 15);
        bits.xor(maskBits);
        if (bits.getSize() != 15) {
            throw new WriterException("should not happen but we got: " + bits.getSize());
        }
    }

    static void makeVersionInfoBits(Version version, BitArray bits) throws WriterException {
        bits.appendBits(version.getVersionNumber(), 6);
        int bchCode = MatrixUtil.calculateBCHCode(version.getVersionNumber(), 7973);
        bits.appendBits(bchCode, 12);
        if (bits.getSize() != 18) {
            throw new WriterException("should not happen but we got: " + bits.getSize());
        }
    }

    private static boolean isEmpty(int value) {
        return value == -1;
    }

    private static void embedTimingPatterns(ByteMatrix matrix) {
        int i = 8;
        while (i < matrix.getWidth() - 8) {
            int bit = (i + 1) % 2;
            if (MatrixUtil.isEmpty(matrix.get(i, 6))) {
                matrix.set(i, 6, bit);
            }
            if (MatrixUtil.isEmpty(matrix.get(6, i))) {
                matrix.set(6, i, bit);
            }
            ++i;
        }
    }

    private static void embedDarkDotAtLeftBottomCorner(ByteMatrix matrix) throws WriterException {
        if (matrix.get(8, matrix.getHeight() - 8) == 0) {
            throw new WriterException();
        }
        matrix.set(8, matrix.getHeight() - 8, 1);
    }

    private static void embedHorizontalSeparationPattern(int xStart, int yStart, ByteMatrix matrix) throws WriterException {
        int x = 0;
        while (x < 8) {
            if (!MatrixUtil.isEmpty(matrix.get(xStart + x, yStart))) {
                throw new WriterException();
            }
            matrix.set(xStart + x, yStart, 0);
            ++x;
        }
    }

    private static void embedVerticalSeparationPattern(int xStart, int yStart, ByteMatrix matrix) throws WriterException {
        int y = 0;
        while (y < 7) {
            if (!MatrixUtil.isEmpty(matrix.get(xStart, yStart + y))) {
                throw new WriterException();
            }
            matrix.set(xStart, yStart + y, 0);
            ++y;
        }
    }

    private static void embedPositionAdjustmentPattern(int xStart, int yStart, ByteMatrix matrix) {
        int y = 0;
        while (y < 5) {
            int[] patternY = POSITION_ADJUSTMENT_PATTERN[y];
            int x = 0;
            while (x < 5) {
                matrix.set(xStart + x, yStart + y, patternY[x]);
                ++x;
            }
            ++y;
        }
    }

    private static void embedPositionDetectionPattern(int xStart, int yStart, ByteMatrix matrix) {
        int y = 0;
        while (y < 7) {
            int[] patternY = POSITION_DETECTION_PATTERN[y];
            int x = 0;
            while (x < 7) {
                matrix.set(xStart + x, yStart + y, patternY[x]);
                ++x;
            }
            ++y;
        }
    }

    private static void embedPositionDetectionPatternsAndSeparators(ByteMatrix matrix) throws WriterException {
        int pdpWidth = POSITION_DETECTION_PATTERN[0].length;
        MatrixUtil.embedPositionDetectionPattern(0, 0, matrix);
        MatrixUtil.embedPositionDetectionPattern(matrix.getWidth() - pdpWidth, 0, matrix);
        MatrixUtil.embedPositionDetectionPattern(0, matrix.getWidth() - pdpWidth, matrix);
        int hspWidth = 8;
        MatrixUtil.embedHorizontalSeparationPattern(0, hspWidth - 1, matrix);
        MatrixUtil.embedHorizontalSeparationPattern(matrix.getWidth() - hspWidth, hspWidth - 1, matrix);
        MatrixUtil.embedHorizontalSeparationPattern(0, matrix.getWidth() - hspWidth, matrix);
        int vspSize = 7;
        MatrixUtil.embedVerticalSeparationPattern(vspSize, 0, matrix);
        MatrixUtil.embedVerticalSeparationPattern(matrix.getHeight() - vspSize - 1, 0, matrix);
        MatrixUtil.embedVerticalSeparationPattern(vspSize, matrix.getHeight() - vspSize, matrix);
    }

    private static void maybeEmbedPositionAdjustmentPatterns(Version version, ByteMatrix matrix) {
        int[] coordinates;
        if (version.getVersionNumber() < 2) {
            return;
        }
        int index = version.getVersionNumber() - 1;
        int[] nArray = coordinates = POSITION_ADJUSTMENT_PATTERN_COORDINATE_TABLE[index];
        int n = coordinates.length;
        int n2 = 0;
        while (n2 < n) {
            int y = nArray[n2];
            if (y >= 0) {
                int[] nArray2 = coordinates;
                int n3 = coordinates.length;
                int n4 = 0;
                while (n4 < n3) {
                    int x = nArray2[n4];
                    if (x >= 0 && MatrixUtil.isEmpty(matrix.get(x, y))) {
                        MatrixUtil.embedPositionAdjustmentPattern(x - 2, y - 2, matrix);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }
}

