/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned.rss.expanded;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitArray;
import com.google.zxing.common.detector.MathUtils;
import com.google.zxing.oned.rss.AbstractRSSReader;
import com.google.zxing.oned.rss.DataCharacter;
import com.google.zxing.oned.rss.FinderPattern;
import com.google.zxing.oned.rss.RSSUtils;
import com.google.zxing.oned.rss.expanded.BitArrayBuilder;
import com.google.zxing.oned.rss.expanded.ExpandedPair;
import com.google.zxing.oned.rss.expanded.ExpandedRow;
import com.google.zxing.oned.rss.expanded.decoders.AbstractExpandedDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class RSSExpandedReader
extends AbstractRSSReader {
    private static final int[] SYMBOL_WIDEST = new int[]{7, 5, 4, 3, 1};
    private static final int[] EVEN_TOTAL_SUBSET = new int[]{4, 20, 52, 104, 204};
    private static final int[] GSUM;
    private static final int[][] FINDER_PATTERNS;
    private static final int[][] WEIGHTS;
    private static final int FINDER_PAT_A = 0;
    private static final int FINDER_PAT_B = 1;
    private static final int FINDER_PAT_C = 2;
    private static final int FINDER_PAT_D = 3;
    private static final int FINDER_PAT_E = 4;
    private static final int FINDER_PAT_F = 5;
    private static final int[][] FINDER_PATTERN_SEQUENCES;
    private static final int MAX_PAIRS = 11;
    private final List<ExpandedPair> pairs = new ArrayList<ExpandedPair>(11);
    private final List<ExpandedRow> rows = new ArrayList<ExpandedRow>();
    private final int[] startEnd = new int[2];
    private boolean startFromEven;

    static {
        int[] nArray = new int[5];
        nArray[1] = 348;
        nArray[2] = 1388;
        nArray[3] = 2948;
        nArray[4] = 3988;
        GSUM = nArray;
        FINDER_PATTERNS = new int[][]{{1, 8, 4, 1}, {3, 6, 4, 1}, {3, 4, 6, 1}, {3, 2, 8, 1}, {2, 6, 5, 1}, {2, 2, 9, 1}};
        WEIGHTS = new int[][]{{1, 3, 9, 27, 81, 32, 96, 77}, {20, 60, 180, 118, 143, 7, 21, 63}, {189, 145, 13, 39, 117, 140, 209, 205}, {193, 157, 49, 147, 19, 57, 171, 91}, {62, 186, 136, 197, 169, 85, 44, 132}, {185, 133, 188, 142, 4, 12, 36, 108}, {113, 128, 173, 97, 80, 29, 87, 50}, {150, 28, 84, 41, 123, 158, 52, 156}, {46, 138, 203, 187, 139, 206, 196, 166}, {76, 17, 51, 153, 37, 111, 122, 155}, {43, 129, 176, 106, 107, 110, 119, 146}, {16, 48, 144, 10, 30, 90, 59, 177}, {109, 116, 137, 200, 178, 112, 125, 164}, {70, 210, 208, 202, 184, 130, 179, 115}, {134, 191, 151, 31, 93, 68, 204, 190}, {148, 22, 66, 198, 172, 94, 71, 2}, {6, 18, 54, 162, 64, 192, 154, 40}, {120, 149, 25, 75, 14, 42, 126, 167}, {79, 26, 78, 23, 69, 207, 199, 175}, {103, 98, 83, 38, 114, 131, 182, 124}, {161, 61, 183, 127, 170, 88, 53, 159}, {55, 165, 73, 8, 24, 72, 5, 15}, {45, 135, 194, 160, 58, 174, 100, 89}};
        int[][] nArrayArray = new int[10][];
        nArrayArray[0] = new int[2];
        int[] nArray2 = new int[3];
        nArray2[1] = 1;
        nArray2[2] = 1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[4];
        nArray3[1] = 2;
        nArray3[2] = 1;
        nArray3[3] = 3;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[5];
        nArray4[1] = 4;
        nArray4[2] = 1;
        nArray4[3] = 3;
        nArray4[4] = 2;
        nArrayArray[3] = nArray4;
        int[] nArray5 = new int[6];
        nArray5[1] = 4;
        nArray5[2] = 1;
        nArray5[3] = 3;
        nArray5[4] = 3;
        nArray5[5] = 5;
        nArrayArray[4] = nArray5;
        int[] nArray6 = new int[7];
        nArray6[1] = 4;
        nArray6[2] = 1;
        nArray6[3] = 3;
        nArray6[4] = 4;
        nArray6[5] = 5;
        nArray6[6] = 5;
        nArrayArray[5] = nArray6;
        int[] nArray7 = new int[8];
        nArray7[2] = 1;
        nArray7[3] = 1;
        nArray7[4] = 2;
        nArray7[5] = 2;
        nArray7[6] = 3;
        nArray7[7] = 3;
        nArrayArray[6] = nArray7;
        int[] nArray8 = new int[9];
        nArray8[2] = 1;
        nArray8[3] = 1;
        nArray8[4] = 2;
        nArray8[5] = 2;
        nArray8[6] = 3;
        nArray8[7] = 4;
        nArray8[8] = 4;
        nArrayArray[7] = nArray8;
        int[] nArray9 = new int[10];
        nArray9[2] = 1;
        nArray9[3] = 1;
        nArray9[4] = 2;
        nArray9[5] = 2;
        nArray9[6] = 3;
        nArray9[7] = 4;
        nArray9[8] = 5;
        nArray9[9] = 5;
        nArrayArray[8] = nArray9;
        int[] nArray10 = new int[11];
        nArray10[2] = 1;
        nArray10[3] = 1;
        nArray10[4] = 2;
        nArray10[5] = 3;
        nArray10[6] = 3;
        nArray10[7] = 4;
        nArray10[8] = 4;
        nArray10[9] = 5;
        nArray10[10] = 5;
        nArrayArray[9] = nArray10;
        FINDER_PATTERN_SEQUENCES = nArrayArray;
    }

    @Override
    public Result decodeRow(int rowNumber, BitArray row, Map<DecodeHintType, ?> hints) throws NotFoundException, FormatException {
        this.pairs.clear();
        this.startFromEven = false;
        try {
            return RSSExpandedReader.constructResult(this.decodeRow2pairs(rowNumber, row));
        }
        catch (NotFoundException notFoundException) {
            this.pairs.clear();
            this.startFromEven = true;
            return RSSExpandedReader.constructResult(this.decodeRow2pairs(rowNumber, row));
        }
    }

    @Override
    public void reset() {
        this.pairs.clear();
        this.rows.clear();
    }

    List<ExpandedPair> decodeRow2pairs(int rowNumber, BitArray row) throws NotFoundException {
        boolean done = false;
        while (!done) {
            try {
                this.pairs.add(this.retrieveNextPair(row, this.pairs, rowNumber));
            }
            catch (NotFoundException nfe) {
                if (this.pairs.isEmpty()) {
                    throw nfe;
                }
                done = true;
            }
        }
        if (this.checkChecksum()) {
            return this.pairs;
        }
        boolean tryStackedDecode = !this.rows.isEmpty();
        this.storeRow(rowNumber, false);
        if (tryStackedDecode) {
            List<ExpandedPair> ps = this.checkRows(false);
            if (ps != null) {
                return ps;
            }
            ps = this.checkRows(true);
            if (ps != null) {
                return ps;
            }
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private List<ExpandedPair> checkRows(boolean reverse) {
        if (this.rows.size() > 25) {
            this.rows.clear();
            return null;
        }
        this.pairs.clear();
        if (reverse) {
            Collections.reverse(this.rows);
        }
        List<ExpandedPair> ps = null;
        try {
            ps = this.checkRows(new ArrayList<ExpandedRow>(), 0);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        if (reverse) {
            Collections.reverse(this.rows);
        }
        return ps;
    }

    private List<ExpandedPair> checkRows(List<ExpandedRow> collectedRows, int currentRow) throws NotFoundException {
        int i = currentRow;
        while (i < this.rows.size()) {
            ExpandedRow row = this.rows.get(i);
            this.pairs.clear();
            for (ExpandedRow collectedRow : collectedRows) {
                this.pairs.addAll(collectedRow.getPairs());
            }
            this.pairs.addAll(row.getPairs());
            if (RSSExpandedReader.isValidSequence(this.pairs)) {
                if (this.checkChecksum()) {
                    return this.pairs;
                }
                ArrayList<ExpandedRow> rs = new ArrayList<ExpandedRow>(collectedRows);
                rs.add(row);
                try {
                    return this.checkRows(rs, i + 1);
                }
                catch (NotFoundException notFoundException) {
                    // empty catch block
                }
            }
            ++i;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static boolean isValidSequence(List<ExpandedPair> pairs) {
        int[][] nArray = FINDER_PATTERN_SEQUENCES;
        int n = FINDER_PATTERN_SEQUENCES.length;
        int n2 = 0;
        while (n2 < n) {
            int[] sequence = nArray[n2];
            if (pairs.size() <= sequence.length) {
                boolean stop = true;
                int j = 0;
                while (j < pairs.size()) {
                    if (pairs.get(j).getFinderPattern().getValue() != sequence[j]) {
                        stop = false;
                        break;
                    }
                    ++j;
                }
                if (stop) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    private void storeRow(int rowNumber, boolean wasReversed) {
        int insertPos = 0;
        boolean prevIsSame = false;
        boolean nextIsSame = false;
        while (insertPos < this.rows.size()) {
            ExpandedRow erow = this.rows.get(insertPos);
            if (erow.getRowNumber() > rowNumber) {
                nextIsSame = erow.isEquivalent(this.pairs);
                break;
            }
            prevIsSame = erow.isEquivalent(this.pairs);
            ++insertPos;
        }
        if (nextIsSame || prevIsSame) {
            return;
        }
        if (RSSExpandedReader.isPartialRow(this.pairs, this.rows)) {
            return;
        }
        this.rows.add(insertPos, new ExpandedRow(this.pairs, rowNumber, wasReversed));
        RSSExpandedReader.removePartialRows(this.pairs, this.rows);
    }

    private static void removePartialRows(List<ExpandedPair> pairs, List<ExpandedRow> rows) {
        Iterator<ExpandedRow> iterator = rows.iterator();
        while (iterator.hasNext()) {
            ExpandedRow r = iterator.next();
            if (r.getPairs().size() == pairs.size()) continue;
            boolean allFound = true;
            for (ExpandedPair p : r.getPairs()) {
                boolean found = false;
                for (ExpandedPair pp : pairs) {
                    if (!p.equals(pp)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                allFound = false;
                break;
            }
            if (!allFound) continue;
            iterator.remove();
        }
    }

    private static boolean isPartialRow(Iterable<ExpandedPair> pairs, Iterable<ExpandedRow> rows) {
        for (ExpandedRow r : rows) {
            boolean allFound = true;
            for (ExpandedPair p : pairs) {
                boolean found = false;
                for (ExpandedPair pp : r.getPairs()) {
                    if (!p.equals(pp)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                allFound = false;
                break;
            }
            if (!allFound) continue;
            return true;
        }
        return false;
    }

    List<ExpandedRow> getRows() {
        return this.rows;
    }

    static Result constructResult(List<ExpandedPair> pairs) throws NotFoundException, FormatException {
        BitArray binary = BitArrayBuilder.buildBitArray(pairs);
        AbstractExpandedDecoder decoder = AbstractExpandedDecoder.createDecoder(binary);
        String resultingString = decoder.parseInformation();
        ResultPoint[] firstPoints = pairs.get(0).getFinderPattern().getResultPoints();
        ResultPoint[] lastPoints = pairs.get(pairs.size() - 1).getFinderPattern().getResultPoints();
        return new Result(resultingString, null, new ResultPoint[]{firstPoints[0], firstPoints[1], lastPoints[0], lastPoints[1]}, BarcodeFormat.RSS_EXPANDED);
    }

    private boolean checkChecksum() {
        ExpandedPair firstPair = this.pairs.get(0);
        DataCharacter checkCharacter = firstPair.getLeftChar();
        DataCharacter firstCharacter = firstPair.getRightChar();
        if (firstCharacter == null) {
            return false;
        }
        int checksum = firstCharacter.getChecksumPortion();
        int s = 2;
        int i = 1;
        while (i < this.pairs.size()) {
            ExpandedPair currentPair = this.pairs.get(i);
            checksum += currentPair.getLeftChar().getChecksumPortion();
            ++s;
            DataCharacter currentRightChar = currentPair.getRightChar();
            if (currentRightChar != null) {
                checksum += currentRightChar.getChecksumPortion();
                ++s;
            }
            ++i;
        }
        int checkCharacterValue = 211 * (s - 4) + (checksum %= 211);
        return checkCharacterValue == checkCharacter.getValue();
    }

    private static int getNextSecondBar(BitArray row, int initialPos) {
        int currentPos;
        if (row.get(initialPos)) {
            currentPos = row.getNextUnset(initialPos);
            currentPos = row.getNextSet(currentPos);
        } else {
            currentPos = row.getNextSet(initialPos);
            currentPos = row.getNextUnset(currentPos);
        }
        return currentPos;
    }

    ExpandedPair retrieveNextPair(BitArray row, List<ExpandedPair> previousPairs, int rowNumber) throws NotFoundException {
        DataCharacter rightChar;
        FinderPattern pattern;
        boolean isOddPattern;
        boolean bl = isOddPattern = previousPairs.size() % 2 == 0;
        if (this.startFromEven) {
            isOddPattern = !isOddPattern;
        }
        boolean keepFinding = true;
        int forcedOffset = -1;
        do {
            this.findNextPair(row, previousPairs, forcedOffset);
            pattern = this.parseFoundFinderPattern(row, rowNumber, isOddPattern);
            if (pattern == null) {
                forcedOffset = RSSExpandedReader.getNextSecondBar(row, this.startEnd[0]);
                continue;
            }
            keepFinding = false;
        } while (keepFinding);
        DataCharacter leftChar = this.decodeDataCharacter(row, pattern, isOddPattern, true);
        if (!previousPairs.isEmpty() && previousPairs.get(previousPairs.size() - 1).mustBeLast()) {
            throw NotFoundException.getNotFoundInstance();
        }
        try {
            rightChar = this.decodeDataCharacter(row, pattern, isOddPattern, false);
        }
        catch (NotFoundException ignored) {
            rightChar = null;
        }
        return new ExpandedPair(leftChar, rightChar, pattern);
    }

    private void findNextPair(BitArray row, List<ExpandedPair> previousPairs, int forcedOffset) throws NotFoundException {
        boolean searchingEvenPair;
        int rowOffset;
        int[] counters = this.getDecodeFinderCounters();
        counters[0] = 0;
        counters[1] = 0;
        counters[2] = 0;
        counters[3] = 0;
        int width = row.getSize();
        if (forcedOffset >= 0) {
            rowOffset = forcedOffset;
        } else if (previousPairs.isEmpty()) {
            rowOffset = 0;
        } else {
            ExpandedPair lastPair = previousPairs.get(previousPairs.size() - 1);
            rowOffset = lastPair.getFinderPattern().getStartEnd()[1];
        }
        boolean bl = searchingEvenPair = previousPairs.size() % 2 != 0;
        if (this.startFromEven) {
            searchingEvenPair = !searchingEvenPair;
        }
        boolean isWhite = false;
        while (rowOffset < width) {
            boolean bl2 = isWhite = !row.get(rowOffset);
            if (!isWhite) break;
            ++rowOffset;
        }
        int counterPosition = 0;
        int patternStart = rowOffset;
        int x = rowOffset;
        while (x < width) {
            if (row.get(x) != isWhite) {
                int n = counterPosition;
                counters[n] = counters[n] + 1;
            } else {
                if (counterPosition == 3) {
                    if (searchingEvenPair) {
                        RSSExpandedReader.reverseCounters(counters);
                    }
                    if (RSSExpandedReader.isFinderPattern(counters)) {
                        this.startEnd[0] = patternStart;
                        this.startEnd[1] = x;
                        return;
                    }
                    if (searchingEvenPair) {
                        RSSExpandedReader.reverseCounters(counters);
                    }
                    patternStart += counters[0] + counters[1];
                    counters[0] = counters[2];
                    counters[1] = counters[3];
                    counters[2] = 0;
                    counters[3] = 0;
                    --counterPosition;
                } else {
                    ++counterPosition;
                }
                counters[counterPosition] = 1;
                isWhite = !isWhite;
            }
            ++x;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static void reverseCounters(int[] counters) {
        int length = counters.length;
        int i = 0;
        while (i < length / 2) {
            int tmp = counters[i];
            counters[i] = counters[length - i - 1];
            counters[length - i - 1] = tmp;
            ++i;
        }
    }

    private FinderPattern parseFoundFinderPattern(BitArray row, int rowNumber, boolean oddPattern) {
        int value;
        int end;
        int start;
        int firstCounter;
        if (oddPattern) {
            int firstElementStart = this.startEnd[0] - 1;
            while (firstElementStart >= 0 && !row.get(firstElementStart)) {
                --firstElementStart;
            }
            firstCounter = this.startEnd[0] - ++firstElementStart;
            start = firstElementStart;
            end = this.startEnd[1];
        } else {
            start = this.startEnd[0];
            end = row.getNextUnset(this.startEnd[1] + 1);
            firstCounter = end - this.startEnd[1];
        }
        int[] counters = this.getDecodeFinderCounters();
        System.arraycopy(counters, 0, counters, 1, counters.length - 1);
        counters[0] = firstCounter;
        try {
            value = RSSExpandedReader.parseFinderValue(counters, FINDER_PATTERNS);
        }
        catch (NotFoundException ignored) {
            return null;
        }
        return new FinderPattern(value, new int[]{start, end}, start, end, rowNumber);
    }

    DataCharacter decodeDataCharacter(BitArray row, FinderPattern pattern, boolean isOddPattern, boolean leftChar) throws NotFoundException {
        int[] counters = this.getDataCharacterCounters();
        int x = 0;
        while (x < counters.length) {
            counters[x] = 0;
            ++x;
        }
        if (leftChar) {
            RSSExpandedReader.recordPatternInReverse(row, pattern.getStartEnd()[0], counters);
        } else {
            RSSExpandedReader.recordPattern(row, pattern.getStartEnd()[1], counters);
            int i = 0;
            int j = counters.length - 1;
            while (i < j) {
                int temp = counters[i];
                counters[i] = counters[j];
                counters[j] = temp;
                ++i;
                --j;
            }
        }
        int numModules = 17;
        float elementWidth = (float)MathUtils.sum(counters) / (float)numModules;
        float expectedElementWidth = (float)(pattern.getStartEnd()[1] - pattern.getStartEnd()[0]) / 15.0f;
        if (Math.abs(elementWidth - expectedElementWidth) / expectedElementWidth > 0.3f) {
            throw NotFoundException.getNotFoundInstance();
        }
        int[] oddCounts = this.getOddCounts();
        int[] evenCounts = this.getEvenCounts();
        float[] oddRoundingErrors = this.getOddRoundingErrors();
        float[] evenRoundingErrors = this.getEvenRoundingErrors();
        int i = 0;
        while (i < counters.length) {
            float value = 1.0f * (float)counters[i] / elementWidth;
            int count = (int)(value + 0.5f);
            if (count < 1) {
                if (value < 0.3f) {
                    throw NotFoundException.getNotFoundInstance();
                }
                count = 1;
            } else if (count > 8) {
                if (value > 8.7f) {
                    throw NotFoundException.getNotFoundInstance();
                }
                count = 8;
            }
            int offset = i / 2;
            if ((i & 1) == 0) {
                oddCounts[offset] = count;
                oddRoundingErrors[offset] = value - (float)count;
            } else {
                evenCounts[offset] = count;
                evenRoundingErrors[offset] = value - (float)count;
            }
            ++i;
        }
        this.adjustOddEvenCounts(numModules);
        int weightRowNumber = 4 * pattern.getValue() + (isOddPattern ? 0 : 2) + (leftChar ? 0 : 1) - 1;
        int oddSum = 0;
        int oddChecksumPortion = 0;
        int i2 = oddCounts.length - 1;
        while (i2 >= 0) {
            if (RSSExpandedReader.isNotA1left(pattern, isOddPattern, leftChar)) {
                int weight = WEIGHTS[weightRowNumber][2 * i2];
                oddChecksumPortion += oddCounts[i2] * weight;
            }
            oddSum += oddCounts[i2];
            --i2;
        }
        int evenChecksumPortion = 0;
        int i3 = evenCounts.length - 1;
        while (i3 >= 0) {
            if (RSSExpandedReader.isNotA1left(pattern, isOddPattern, leftChar)) {
                int weight = WEIGHTS[weightRowNumber][2 * i3 + 1];
                evenChecksumPortion += evenCounts[i3] * weight;
            }
            --i3;
        }
        int checksumPortion = oddChecksumPortion + evenChecksumPortion;
        if ((oddSum & 1) != 0 || oddSum > 13 || oddSum < 4) {
            throw NotFoundException.getNotFoundInstance();
        }
        int group = (13 - oddSum) / 2;
        int oddWidest = SYMBOL_WIDEST[group];
        int evenWidest = 9 - oddWidest;
        int vOdd = RSSUtils.getRSSvalue(oddCounts, oddWidest, true);
        int vEven = RSSUtils.getRSSvalue(evenCounts, evenWidest, false);
        int tEven = EVEN_TOTAL_SUBSET[group];
        int gSum = GSUM[group];
        int value = vOdd * tEven + vEven + gSum;
        return new DataCharacter(value, checksumPortion);
    }

    private static boolean isNotA1left(FinderPattern pattern, boolean isOddPattern, boolean leftChar) {
        return pattern.getValue() != 0 || !isOddPattern || !leftChar;
    }

    private void adjustOddEvenCounts(int numModules) throws NotFoundException {
        boolean evenParityBad;
        int oddSum = MathUtils.sum(this.getOddCounts());
        int evenSum = MathUtils.sum(this.getEvenCounts());
        boolean incrementOdd = false;
        boolean decrementOdd = false;
        if (oddSum > 13) {
            decrementOdd = true;
        } else if (oddSum < 4) {
            incrementOdd = true;
        }
        boolean incrementEven = false;
        boolean decrementEven = false;
        if (evenSum > 13) {
            decrementEven = true;
        } else if (evenSum < 4) {
            incrementEven = true;
        }
        int mismatch = oddSum + evenSum - numModules;
        boolean oddParityBad = (oddSum & 1) == 1;
        boolean bl = evenParityBad = (evenSum & 1) == 0;
        if (mismatch == 1) {
            if (oddParityBad) {
                if (evenParityBad) {
                    throw NotFoundException.getNotFoundInstance();
                }
                decrementOdd = true;
            } else {
                if (!evenParityBad) {
                    throw NotFoundException.getNotFoundInstance();
                }
                decrementEven = true;
            }
        } else if (mismatch == -1) {
            if (oddParityBad) {
                if (evenParityBad) {
                    throw NotFoundException.getNotFoundInstance();
                }
                incrementOdd = true;
            } else {
                if (!evenParityBad) {
                    throw NotFoundException.getNotFoundInstance();
                }
                incrementEven = true;
            }
        } else if (mismatch == 0) {
            if (oddParityBad) {
                if (!evenParityBad) {
                    throw NotFoundException.getNotFoundInstance();
                }
                if (oddSum < evenSum) {
                    incrementOdd = true;
                    decrementEven = true;
                } else {
                    decrementOdd = true;
                    incrementEven = true;
                }
            } else if (evenParityBad) {
                throw NotFoundException.getNotFoundInstance();
            }
        } else {
            throw NotFoundException.getNotFoundInstance();
        }
        if (incrementOdd) {
            if (decrementOdd) {
                throw NotFoundException.getNotFoundInstance();
            }
            RSSExpandedReader.increment(this.getOddCounts(), this.getOddRoundingErrors());
        }
        if (decrementOdd) {
            RSSExpandedReader.decrement(this.getOddCounts(), this.getOddRoundingErrors());
        }
        if (incrementEven) {
            if (decrementEven) {
                throw NotFoundException.getNotFoundInstance();
            }
            RSSExpandedReader.increment(this.getEvenCounts(), this.getOddRoundingErrors());
        }
        if (decrementEven) {
            RSSExpandedReader.decrement(this.getEvenCounts(), this.getEvenRoundingErrors());
        }
    }
}

